"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchRelatedAlertsBySession = void 0;
var _react = require("react");
var _use_alert_prevalence = require("../../../../common/containers/alerts/use_alert_prevalence");
var _helpers = require("../../../../helpers");
var _field_names = require("../constants/field_names");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns the number of alerts by session for the document (and the loading, error statuses as well as the alerts count)
 */
const useFetchRelatedAlertsBySession = ({
  entityId,
  scopeId
}) => {
  const {
    loading,
    error,
    count,
    alertIds
  } = (0, _use_alert_prevalence.useAlertPrevalence)({
    field: _field_names.ENTRY_LEADER_ENTITY_ID,
    value: entityId,
    isActiveTimelines: (0, _helpers.isActiveTimeline)(scopeId),
    signalIndexName: null,
    includeAlertIds: true,
    ignoreTimerange: true
  });
  return (0, _react.useMemo)(() => ({
    loading,
    error,
    data: alertIds || [],
    dataCount: count || 0
  }), [alertIds, count, error, loading]);
};
exports.useFetchRelatedAlertsBySession = useFetchRelatedAlertsBySession;