"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RightPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _panel_keys = require("../shared/constants/panel_keys");
var _use_tabs = require("./hooks/use_tabs");
var _local_storage = require("../shared/constants/local_storage");
var _kibana = require("../../../common/lib/kibana");
var _context = require("./context");
var _navigation = require("./navigation");
var _header = require("./header");
var _content = require("./content");
var _tour = require("./components/tour");
var _footer = require("./footer");
var _use_flyout_is_expandable = require("./hooks/use_flyout_is_expandable");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Panel to be displayed in the document details expandable flyout right section
 */
const RightPanel = exports.RightPanel = /*#__PURE__*/(0, _react.memo)(({
  path
}) => {
  const {
    storage,
    telemetry
  } = (0, _kibana.useKibana)().services;
  const {
    openRightPanel,
    closeFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const {
    eventId,
    indexName,
    scopeId,
    isPreview,
    dataAsNestedObject,
    getFieldsData
  } = (0, _context.useRightPanelContext)();

  // if the flyout is expandable we render all 3 tabs (overview, table and json)
  // if the flyout is not, we render only table and json
  const flyoutIsExpandable = (0, _use_flyout_is_expandable.useFlyoutIsExpandable)({
    getFieldsData,
    dataAsNestedObject
  });
  const {
    tabsDisplayed,
    selectedTabId
  } = (0, _use_tabs.useTabs)({
    flyoutIsExpandable,
    path
  });
  const setSelectedTabId = tabId => {
    openRightPanel({
      id: _panel_keys.DocumentDetailsRightPanelKey,
      path: {
        tab: tabId
      },
      params: {
        id: eventId,
        indexName,
        scopeId
      }
    });

    // saving which tab is currently selected in the right panel in local storage
    storage.set(_local_storage.FLYOUT_STORAGE_KEYS.RIGHT_PANEL_SELECTED_TABS, tabId);
    telemetry.reportDetailsFlyoutTabClicked({
      location: scopeId,
      panel: 'right',
      tabId
    });
  };

  // If flyout is open in preview mode, do not reload with stale information
  (0, _react.useEffect)(() => {
    const beforeUnloadHandler = () => {
      if (isPreview) {
        closeFlyout();
      }
    };
    window.addEventListener('beforeunload', beforeUnloadHandler);
    return () => {
      window.removeEventListener('beforeunload', beforeUnloadHandler);
    };
  }, [isPreview, closeFlyout]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, flyoutIsExpandable && /*#__PURE__*/_react.default.createElement(_tour.RightPanelTour, null), /*#__PURE__*/_react.default.createElement(_navigation.PanelNavigation, {
    flyoutIsExpandable: flyoutIsExpandable
  }), /*#__PURE__*/_react.default.createElement(_header.PanelHeader, {
    tabs: tabsDisplayed,
    selectedTabId: selectedTabId,
    setSelectedTabId: setSelectedTabId
  }), /*#__PURE__*/_react.default.createElement(_content.PanelContent, {
    tabs: tabsDisplayed,
    selectedTabId: selectedTabId
  }), /*#__PURE__*/_react.default.createElement(_footer.PanelFooter, {
    isPreview: isPreview
  }));
});
RightPanel.displayName = 'RightPanel';