"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserEntityOverview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _fp = require("lodash/fp");
var _i18n = require("@kbn/i18n");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _panel_keys = require("../../shared/constants/panel_keys");
var _left = require("../../left");
var _entities_details = require("../../left/components/entities_details");
var _context = require("../context");
var _utils = require("../../shared/utils");
var _cell_actions = require("./cell_actions");
var _first_last_seen = require("../../../../common/components/first_last_seen/first_last_seen");
var _search_strategy = require("../../../../../common/search_strategy");
var _empty_value = require("../../../../common/components/empty_value");
var _page = require("../../../../common/components/page");
var _overview_description_list = require("../../../../common/components/overview_description_list");
var _common = require("../../../../entity_analytics/components/severity/common");
var _sourcerer = require("../../../../common/containers/sourcerer");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _use_risk_score = require("../../../../entity_analytics/api/hooks/use_risk_score");
var _translations = require("../../../../overview/components/user_overview/translations");
var _test_ids = require("./test_ids");
var _observed_details = require("../../../../explore/users/containers/users/observed_details");
var _common2 = require("../../../../overview/components/common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const USER_ICON = 'user';
/**
 * User preview content for the entities preview in right flyout. It contains ip addresses and risk level
 */
const UserEntityOverview = ({
  userName
}) => {
  const {
    eventId,
    indexName,
    scopeId
  } = (0, _context.useRightPanelContext)();
  const {
    openLeftPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const goToEntitiesTab = (0, _react.useCallback)(() => {
    openLeftPanel({
      id: _panel_keys.DocumentDetailsLeftPanelKey,
      path: {
        tab: _left.LeftPanelInsightsTab,
        subTab: _entities_details.ENTITIES_TAB_ID
      },
      params: {
        id: eventId,
        indexName,
        scopeId
      }
    });
  }, [eventId, openLeftPanel, indexName, scopeId]);
  const {
    from,
    to
  } = (0, _use_global_time.useGlobalTime)();
  const {
    selectedPatterns
  } = (0, _sourcerer.useSourcererDataView)();
  const timerange = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);
  const filterQuery = (0, _react.useMemo)(() => userName ? (0, _search_strategy.buildUserNamesFilter)([userName]) : undefined, [userName]);
  const [isUserDetailsLoading, {
    userDetails
  }] = (0, _observed_details.useObservedUserDetails)({
    endDate: to,
    userName,
    indexNames: selectedPatterns,
    startDate: from
  });
  const {
    data: userRisk,
    isAuthorized,
    loading: isRiskScoreLoading
  } = (0, _use_risk_score.useRiskScore)({
    filterQuery,
    riskEntity: _search_strategy.RiskScoreEntity.user,
    timerange
  });
  const userDomainValue = (0, _react.useMemo)(() => (0, _utils.getField)((0, _fp.getOr)([], 'user.domain', userDetails)), [userDetails]);
  const userDomain = (0, _react.useMemo)(() => [{
    title: _translations.USER_DOMAIN,
    description: userDomainValue ? /*#__PURE__*/_react.default.createElement(_cell_actions.CellActions, {
      field: 'user.domain',
      value: userDomainValue
    }, userDomainValue) : (0, _empty_value.getEmptyTagValue)()
  }], [userDomainValue]);
  const userLastSeen = (0, _react.useMemo)(() => [{
    title: _translations.LAST_SEEN,
    description: /*#__PURE__*/_react.default.createElement(_first_last_seen.FirstLastSeen, {
      indexPatterns: selectedPatterns,
      field: 'user.name',
      value: userName,
      type: _first_last_seen.FirstLastSeenType.LAST_SEEN
    })
  }], [userName, selectedPatterns]);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const xsFontSize = (0, _eui.useEuiFontSize)('xs').fontSize;
  const [userRiskLevel] = (0, _react.useMemo)(() => {
    const userRiskData = userRisk && userRisk.length > 0 ? userRisk[0] : undefined;
    return [{
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "flexEnd",
        gutterSize: "none",
        responsive: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, _translations.USER_RISK_LEVEL), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_common2.RiskScoreDocTooltip, {
        riskScoreEntity: _search_strategy.RiskScoreEntity.user
      }))),
      description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, userRiskData ? /*#__PURE__*/_react.default.createElement(_common.RiskScoreLevel, {
        severity: userRiskData.user.risk.calculated_level
      }) : (0, _empty_value.getEmptyTagValue)())
    }];
  }, [userRisk]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    responsive: false,
    "data-test-subj": _test_ids.ENTITIES_USER_OVERVIEW_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: USER_ICON
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": _test_ids.ENTITIES_USER_OVERVIEW_LINK_TEST_ID,
    css: (0, _css.css)`
                font-size: ${xsFontSize};
                font-weight: ${euiTheme.font.weight.bold};
              `,
    onClick: goToEntitiesTab
  }, userName)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, isUserDetailsLoading || isRiskScoreLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    contentAriaLabel: _i18n.i18n.translate('xpack.securitySolution.flyout.right.insights.entities.userLoadingAriaLabel', {
      defaultMessage: 'user overview'
    }),
    "data-test-subj": _test_ids.ENTITIES_USER_OVERVIEW_LOADING_TEST_ID
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_overview_description_list.OverviewDescriptionList, {
    dataTestSubj: _test_ids.ENTITIES_USER_OVERVIEW_DOMAIN_TEST_ID,
    descriptionList: userDomain
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, isAuthorized ? /*#__PURE__*/_react.default.createElement(_page.DescriptionListStyled, {
    "data-test-subj": _test_ids.ENTITIES_USER_OVERVIEW_RISK_LEVEL_TEST_ID,
    listItems: [userRiskLevel]
  }) : /*#__PURE__*/_react.default.createElement(_overview_description_list.OverviewDescriptionList, {
    dataTestSubj: _test_ids.ENTITIES_USER_OVERVIEW_LAST_SEEN_TEST_ID,
    descriptionList: userLastSeen
  })))));
};
exports.UserEntityOverview = UserEntityOverview;