"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuppressedAlerts = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _utils = require("../../../../../common/detection_engine/utils");
var _test_ids = require("./test_ids");
var _insights_summary_row = require("./insights_summary_row");
var _translations = require("../../../../common/components/event_details/insights/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Show related alerts by ancestry in summary row
 */
const SuppressedAlerts = ({
  alertSuppressionCount,
  ruleType
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_insights_summary_row.InsightsSummaryRow, {
    loading: false,
    error: false,
    icon: 'layers',
    value: alertSuppressionCount,
    text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.right.insights.correlations.suppressedAlertsLabel",
      defaultMessage: "suppressed {count, plural, =1 {alert} other {alerts}}",
      values: {
        count: alertSuppressionCount
      }
    }),
    "data-test-subj": _test_ids.CORRELATIONS_SUPPRESSED_ALERTS_TEST_ID,
    key: `correlation-row-suppressed-alerts`
  })), ruleType && (0, _utils.isSuppressionRuleInGA)(ruleType) ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: _translations.SUPPRESSED_ALERTS_COUNT_TECHNICAL_PREVIEW,
    size: "s",
    iconType: "beaker",
    tooltipContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.right.insights.entities.suppressedAlertTechnicalPreviewTooltip",
      defaultMessage: "This functionality is in technical preview and may be changed or removed completely in a future release. Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features."
    }),
    tooltipPosition: "bottom",
    "data-test-subj": _test_ids.CORRELATIONS_SUPPRESSED_ALERTS_TECHNICAL_PREVIEW_TEST_ID
  })));
};
exports.SuppressedAlerts = SuppressedAlerts;
SuppressedAlerts.displayName = 'SuppressedAlerts';