"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentSeverity = void 0;
var _react = _interopRequireWildcard(require("react"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _cell_actions = require("./cell_actions");
var _context = require("../context");
var _severity_badge = require("../../../../common/components/severity_badge");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isSeverity = x => x === 'low' || x === 'medium' || x === 'high' || x === 'critical';

/**
 * Document details severity displayed in flyout right section header
 */
const DocumentSeverity = exports.DocumentSeverity = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    getFieldsData
  } = (0, _context.useRightPanelContext)();
  const fieldsData = getFieldsData(_ruleDataUtils.ALERT_SEVERITY);
  if (!fieldsData) {
    return null;
  }
  let alertSeverity;
  if (typeof fieldsData === 'string' && isSeverity(fieldsData)) {
    alertSeverity = fieldsData;
  } else if (Array.isArray(fieldsData) && fieldsData.length > 0 && isSeverity(fieldsData[0])) {
    alertSeverity = fieldsData[0];
  } else {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_cell_actions.CellActions, {
    field: _ruleDataUtils.ALERT_SEVERITY,
    value: alertSeverity
  }, /*#__PURE__*/_react.default.createElement(_severity_badge.SeverityBadge, {
    value: alertSeverity
  }));
});
DocumentSeverity.displayName = 'DocumentSeverity';