"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigationSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_expand_section = require("../hooks/use_expand_section");
var _expandable_section = require("./expandable_section");
var _highlighted_fields = require("./highlighted_fields");
var _test_ids = require("./test_ids");
var _investigation_guide = require("./investigation_guide");
var _utils = require("../../shared/utils");
var _event_kinds = require("../../shared/constants/event_kinds");
var _context = require("../context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KEY = 'investigation';

/**
 * Second section of the overview tab in details flyout.
 * It contains investigation guide (alerts only) and highlighted fields
 */
const InvestigationSection = exports.InvestigationSection = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    getFieldsData
  } = (0, _context.useRightPanelContext)();
  const eventKind = (0, _utils.getField)(getFieldsData('event.kind'));
  const expanded = (0, _use_expand_section.useExpandSection)({
    title: KEY,
    defaultValue: true
  });
  return /*#__PURE__*/_react.default.createElement(_expandable_section.ExpandableSection, {
    expanded: expanded,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.right.investigation.sectionTitle",
      defaultMessage: "Investigation"
    }),
    localStorageKey: KEY,
    gutterSize: "s",
    "data-test-subj": _test_ids.INVESTIGATION_SECTION_TEST_ID
  }, eventKind === _event_kinds.EventKind.signal && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_investigation_guide.InvestigationGuide, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_highlighted_fields.HighlightedFields, null));
});
InvestigationSection.displayName = 'InvestigationSection';