"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostEntityOverview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _fp = require("lodash/fp");
var _i18n = require("@kbn/i18n");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _use_risk_score = require("../../../../entity_analytics/api/hooks/use_risk_score");
var _context = require("../context");
var _first_last_seen = require("../../../../common/components/first_last_seen/first_last_seen");
var _search_strategy = require("../../../../../common/search_strategy");
var _empty_value = require("../../../../common/components/empty_value");
var _page = require("../../../../common/components/page");
var _overview_description_list = require("../../../../common/components/overview_description_list");
var _common = require("../../../../entity_analytics/components/severity/common");
var _sourcerer = require("../../../../common/containers/sourcerer");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _details = require("../../../../explore/hosts/containers/hosts/details");
var _utils = require("../../shared/utils");
var _cell_actions = require("./cell_actions");
var _translations = require("../../../../overview/components/host_overview/translations");
var _entities_details = require("../../left/components/entities_details");
var _test_ids = require("./test_ids");
var _panel_keys = require("../../shared/constants/panel_keys");
var _left = require("../../left");
var _common2 = require("../../../../overview/components/common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HOST_ICON = 'storage';
/**
 * Host preview content for the entities preview in right flyout. It contains ip addresses and risk level
 */
const HostEntityOverview = ({
  hostName
}) => {
  const {
    eventId,
    indexName,
    scopeId
  } = (0, _context.useRightPanelContext)();
  const {
    openLeftPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const goToEntitiesTab = (0, _react.useCallback)(() => {
    openLeftPanel({
      id: _panel_keys.DocumentDetailsLeftPanelKey,
      path: {
        tab: _left.LeftPanelInsightsTab,
        subTab: _entities_details.ENTITIES_TAB_ID
      },
      params: {
        id: eventId,
        indexName,
        scopeId
      }
    });
  }, [eventId, openLeftPanel, indexName, scopeId]);
  const {
    from,
    to
  } = (0, _use_global_time.useGlobalTime)();
  const {
    selectedPatterns
  } = (0, _sourcerer.useSourcererDataView)();
  const timerange = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);
  const filterQuery = (0, _react.useMemo)(() => hostName ? (0, _search_strategy.buildHostNamesFilter)([hostName]) : undefined, [hostName]);
  const {
    data: hostRisk,
    isAuthorized,
    loading: isRiskScoreLoading
  } = (0, _use_risk_score.useRiskScore)({
    filterQuery,
    riskEntity: _search_strategy.RiskScoreEntity.host,
    skip: hostName == null,
    timerange
  });
  const [isHostDetailsLoading, {
    hostDetails
  }] = (0, _details.useHostDetails)({
    hostName,
    indexNames: selectedPatterns,
    startDate: from,
    endDate: to
  });
  const hostOSFamilyValue = (0, _react.useMemo)(() => (0, _utils.getField)((0, _fp.getOr)([], 'host.os.family', hostDetails)), [hostDetails]);
  const hostOSFamily = (0, _react.useMemo)(() => [{
    title: _translations.FAMILY,
    description: hostOSFamilyValue ? /*#__PURE__*/_react.default.createElement(_cell_actions.CellActions, {
      field: 'host.os.family',
      value: hostOSFamilyValue
    }, hostOSFamilyValue) : (0, _empty_value.getEmptyTagValue)()
  }], [hostOSFamilyValue]);
  const hostLastSeen = (0, _react.useMemo)(() => [{
    title: _translations.LAST_SEEN,
    description: /*#__PURE__*/_react.default.createElement(_first_last_seen.FirstLastSeen, {
      indexPatterns: selectedPatterns,
      field: 'host.name',
      value: hostName,
      type: _first_last_seen.FirstLastSeenType.LAST_SEEN
    })
  }], [hostName, selectedPatterns]);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const xsFontSize = (0, _eui.useEuiFontSize)('xs').fontSize;
  const [hostRiskLevel] = (0, _react.useMemo)(() => {
    const hostRiskData = hostRisk && hostRisk.length > 0 ? hostRisk[0] : undefined;
    return [{
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "flexEnd",
        gutterSize: "none",
        responsive: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, _translations.HOST_RISK_LEVEL), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_common2.RiskScoreDocTooltip, {
        riskScoreEntity: _search_strategy.RiskScoreEntity.host
      }))),
      description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hostRiskData ? /*#__PURE__*/_react.default.createElement(_common.RiskScoreLevel, {
        severity: hostRiskData.host.risk.calculated_level
      }) : (0, _empty_value.getEmptyTagValue)())
    }];
  }, [hostRisk]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    responsive: false,
    "data-test-subj": _test_ids.ENTITIES_HOST_OVERVIEW_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: HOST_ICON
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": _test_ids.ENTITIES_HOST_OVERVIEW_LINK_TEST_ID,
    css: (0, _css.css)`
                font-size: ${xsFontSize};
                font-weight: ${euiTheme.font.weight.bold};
              `,
    onClick: goToEntitiesTab
  }, hostName)))), isRiskScoreLoading || isHostDetailsLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    "data-test-subj": _test_ids.ENTITIES_HOST_OVERVIEW_LOADING_TEST_ID,
    contentAriaLabel: _i18n.i18n.translate('xpack.securitySolution.flyout.right.insights.entities.hostLoadingAriaLabel', {
      defaultMessage: 'host overview'
    })
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_overview_description_list.OverviewDescriptionList, {
    dataTestSubj: _test_ids.ENTITIES_HOST_OVERVIEW_OS_FAMILY_TEST_ID,
    descriptionList: hostOSFamily
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, isAuthorized ? /*#__PURE__*/_react.default.createElement(_page.DescriptionListStyled, {
    "data-test-subj": _test_ids.ENTITIES_HOST_OVERVIEW_RISK_LEVEL_TEST_ID,
    listItems: [hostRiskLevel]
  }) : /*#__PURE__*/_react.default.createElement(_overview_description_list.OverviewDescriptionList, {
    dataTestSubj: _test_ids.ENTITIES_HOST_OVERVIEW_LAST_SEEN_TEST_ID,
    descriptionList: hostLastSeen
  })))));
};
exports.HostEntityOverview = HostEntityOverview;
HostEntityOverview.displayName = 'HostEntityOverview';