"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HighlightedFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _highlighted_fields_helpers = require("../../shared/utils/highlighted_fields_helpers");
var _use_rule_with_fallback = require("../../../../detection_engine/rule_management/logic/use_rule_with_fallback");
var _helpers = require("../../../../timelines/components/side_panel/event_details/helpers");
var _highlighted_fields_cell = require("./highlighted_fields_cell");
var _cell_actions = require("./cell_actions");
var _test_ids = require("./test_ids");
var _context = require("../context");
var _use_highlighted_fields = require("../../shared/hooks/use_highlighted_fields");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const columns = [{
  field: 'field',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.investigation.highlightedFields.tableFieldColumnLabel",
    defaultMessage: "Field"
  }),
  'data-test-subj': 'fieldCell',
  width: '30%'
}, {
  field: 'description',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.investigation.highlightedFields.tableValueColumnLabel",
    defaultMessage: "Value"
  }),
  'data-test-subj': 'valueCell',
  width: '70%',
  render: description => /*#__PURE__*/_react.default.createElement(_cell_actions.CellActions, {
    field: description.field,
    value: description.values
  }, /*#__PURE__*/_react.default.createElement(_highlighted_fields_cell.HighlightedFieldsCell, {
    values: description.values,
    field: description.field,
    originalField: description.originalField
  }))
}];

/**
 * Component that displays the highlighted fields in the right panel under the Investigation section.
 */
const HighlightedFields = () => {
  var _maybeRule$investigat, _maybeRule$investigat2;
  const {
    dataFormattedForFieldBrowser,
    scopeId,
    isPreview
  } = (0, _context.useRightPanelContext)();
  const {
    ruleId
  } = (0, _helpers.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  const {
    loading,
    rule: maybeRule
  } = (0, _use_rule_with_fallback.useRuleWithFallback)(ruleId);
  const highlightedFields = (0, _use_highlighted_fields.useHighlightedFields)({
    dataFormattedForFieldBrowser,
    investigationFields: (_maybeRule$investigat = maybeRule === null || maybeRule === void 0 ? void 0 : (_maybeRule$investigat2 = maybeRule.investigation_fields) === null || _maybeRule$investigat2 === void 0 ? void 0 : _maybeRule$investigat2.field_names) !== null && _maybeRule$investigat !== void 0 ? _maybeRule$investigat : []
  });
  const items = (0, _react.useMemo)(() => (0, _highlighted_fields_helpers.convertHighlightedFieldsToTableRow)(highlightedFields, scopeId, isPreview), [highlightedFields, scopeId, isPreview]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": _test_ids.HIGHLIGHTED_FIELDS_TITLE_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.investigation.highlightedFields.highlightedFieldsTitle",
    defaultMessage: "Highlighted fields"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": _test_ids.HIGHLIGHTED_FIELDS_DETAILS_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: items,
    columns: columns,
    compressed: true,
    loading: loading,
    message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.right.investigation.highlightedFields.noDataDescription",
      defaultMessage: "There's no highlighted fields for this alert."
    })
  }))));
};
exports.HighlightedFields = HighlightedFields;