"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventHeaderTitle = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _flyout_title = require("../../../shared/components/flyout_title");
var _severity = require("./severity");
var _helpers = require("../../../../timelines/components/side_panel/event_details/helpers");
var _context = require("../context");
var _formatted_date = require("../../../../common/components/formatted_date");
var _test_ids = require("./test_ids");
var _utils = require("../../shared/utils");
var _event_utils = require("../utils/event_utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Event details flyout right section header
 */
const EventHeaderTitle = exports.EventHeaderTitle = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    dataFormattedForFieldBrowser,
    getFieldsData
  } = (0, _context.useRightPanelContext)();
  const {
    timestamp
  } = (0, _helpers.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  const eventKind = (0, _utils.getField)(getFieldsData('event.kind'));
  const eventCategory = (0, _utils.getField)(getFieldsData('event.category'));
  const title = (0, _react.useMemo)(() => {
    const defaultTitle = _i18n.i18n.translate('xpack.securitySolution.flyout.right.title.eventTitle', {
      defaultMessage: `Event details`
    });
    if (eventKind === 'event' && eventCategory) {
      var _getField;
      const fieldName = _event_utils.EVENT_CATEGORY_TO_FIELD[eventCategory];
      return (_getField = (0, _utils.getField)(getFieldsData(fieldName))) !== null && _getField !== void 0 ? _getField : defaultTitle;
    }
    if (eventKind === 'alert') {
      return _i18n.i18n.translate('xpack.securitySolution.flyout.right.title.alertEventTitle', {
        defaultMessage: 'External alert details'
      });
    }
    return eventKind ? _i18n.i18n.translate('xpack.securitySolution.flyout.right.title.otherEventTitle', {
      defaultMessage: '{eventKind} details',
      values: {
        eventKind: (0, _lodash.startCase)(eventKind)
      }
    }) : defaultTitle;
  }, [eventKind, getFieldsData, eventCategory]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_severity.DocumentSeverity, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), timestamp && /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDate, {
    value: new Date(timestamp)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_flyout_title.FlyoutTitle, {
    title: title,
    iconType: 'analyzeEvent',
    "data-test-subj": _test_ids.FLYOUT_EVENT_HEADER_TITLE_TEST_ID
  }));
});
EventHeaderTitle.displayName = 'EventHeaderTitle';