"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertDescription = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _react2 = require("@emotion/react");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../../common/lib/kibana");
var _context = require("../context");
var _helpers = require("../../../../timelines/components/side_panel/event_details/helpers");
var _test_ids = require("./test_ids");
var _panel_keys = require("../../shared/constants/panel_keys");
var _preview = require("../../preview");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Displays the rule description of a signal document.
 */
const AlertDescription = () => {
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const {
    dataFormattedForFieldBrowser,
    scopeId,
    eventId,
    indexName,
    isPreview
  } = (0, _context.useRightPanelContext)();
  const {
    isAlert,
    ruleDescription,
    ruleName,
    ruleId
  } = (0, _helpers.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  const {
    openPreviewPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const openRulePreview = (0, _react.useCallback)(() => {
    const PreviewPanelRulePreview = {
      tab: _preview.RulePreviewPanel
    };
    openPreviewPanel({
      id: _panel_keys.DocumentDetailsPreviewPanelKey,
      path: PreviewPanelRulePreview,
      params: {
        id: eventId,
        indexName,
        scopeId,
        banner: {
          title: _i18n.i18n.translate('xpack.securitySolution.flyout.right.about.description.rulePreviewTitle', {
            defaultMessage: 'Preview rule details'
          }),
          backgroundColor: 'warning',
          textColor: 'warning'
        },
        ruleId
      }
    });
    telemetry.reportDetailsFlyoutOpened({
      location: scopeId,
      panel: 'preview'
    });
  }, [eventId, openPreviewPanel, indexName, scopeId, ruleId, telemetry]);
  const viewRule = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    iconType: "expand",
    onClick: openRulePreview,
    iconSide: "right",
    "data-test-subj": _test_ids.RULE_SUMMARY_BUTTON_TEST_ID,
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.right.about.description.ruleSummaryButtonAriaLabel', {
      defaultMessage: 'Show rule summary'
    }),
    disabled: (0, _lodash.isEmpty)(ruleName) || (0, _lodash.isEmpty)(ruleId) || isPreview
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.about.description.ruleSummaryButtonLabel",
    defaultMessage: "Show rule summary"
  }))), [ruleName, openRulePreview, ruleId, isPreview]);
  const alertRuleDescription = (ruleDescription === null || ruleDescription === void 0 ? void 0 : ruleDescription.length) > 0 ? ruleDescription : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.about.description.noRuleDescription",
    defaultMessage: "There's no description for this rule."
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": _test_ids.ALERT_DESCRIPTION_TITLE_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, isAlert ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    gutterSize: "none",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.about.description.ruleTitle",
    defaultMessage: "Rule description"
  }))), viewRule) : /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.about.description.documentTitle",
    defaultMessage: "Document description"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": _test_ids.ALERT_DESCRIPTION_DETAILS_TEST_ID
  }, /*#__PURE__*/_react.default.createElement("p", {
    css: (0, _react2.css)`
            word-break: break-word;
            display: -webkit-box;
            -webkit-line-clamp: 3;
            -webkit-box-orient: vertical;
            overflow: hidden;
          `
  }, isAlert ? alertRuleDescription : '-')));
};
exports.AlertDescription = AlertDescription;
AlertDescription.displayName = 'AlertDescription';