"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulePreviewPanel = exports.PreviewPanel = exports.AlertReasonPreviewPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _panels = require("./panels");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RulePreviewPanel = exports.RulePreviewPanel = 'rule-preview';
const AlertReasonPreviewPanel = exports.AlertReasonPreviewPanel = 'alert-reason-preview';
/**
 * Preview panel to be displayed on top of the document details expandable flyout right section
 */
const PreviewPanel = exports.PreviewPanel = /*#__PURE__*/(0, _react.memo)(({
  path
}) => {
  const previewPanel = (0, _react.useMemo)(() => {
    return path ? _panels.panels.find(panel => panel.id === path.tab) : null;
  }, [path]);
  if (!previewPanel) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    direction: "column",
    gutterSize: "none",
    style: {
      height: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      marginTop: '-15px'
    }
  }, previewPanel.content), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, previewPanel.footer));
});
PreviewPanel.displayName = 'PreviewPanel';