"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizeTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _context = require("../context");
var _panel_keys = require("../../shared/constants/panel_keys");
var _ = require("..");
var _test_ids = require("./test_ids");
var _analyze_graph = require("../components/analyze_graph");
var _session_view = require("../components/session_view");
var _user_actions = require("../../../../common/lib/apm/user_actions");
var _use_start_transaction = require("../../../../common/lib/apm/use_start_transaction");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const visualizeButtons = [{
  id: _session_view.SESSION_VIEW_ID,
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.visualize.sessionViewButtonLabel",
    defaultMessage: "Session View"
  }),
  'data-test-subj': _test_ids.VISUALIZE_TAB_SESSION_VIEW_BUTTON_TEST_ID
}, {
  id: _analyze_graph.ANALYZE_GRAPH_ID,
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.visualize.analyzerGraphButtonLabel",
    defaultMessage: "Analyzer Graph"
  }),
  'data-test-subj': _test_ids.VISUALIZE_TAB_GRAPH_ANALYZER_BUTTON_TEST_ID
}];

/**
 * Visualize view displayed in the document details expandable flyout left section
 */
const VisualizeTab = exports.VisualizeTab = /*#__PURE__*/(0, _react.memo)(() => {
  var _panels$left$path$sub, _panels$left, _panels$left$path, _panels$left4, _panels$left4$path;
  const {
    eventId,
    indexName,
    scopeId
  } = (0, _context.useLeftPanelContext)();
  const {
    openLeftPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const panels = (0, _expandableFlyout.useExpandableFlyoutState)();
  const [activeVisualizationId, setActiveVisualizationId] = (0, _react.useState)((_panels$left$path$sub = (_panels$left = panels.left) === null || _panels$left === void 0 ? void 0 : (_panels$left$path = _panels$left.path) === null || _panels$left$path === void 0 ? void 0 : _panels$left$path.subTab) !== null && _panels$left$path$sub !== void 0 ? _panels$left$path$sub : _session_view.SESSION_VIEW_ID);
  const {
    startTransaction
  } = (0, _use_start_transaction.useStartTransaction)();
  const onChangeCompressed = (0, _react.useCallback)(optionId => {
    setActiveVisualizationId(optionId);
    if (optionId === _analyze_graph.ANALYZE_GRAPH_ID) {
      startTransaction({
        name: _user_actions.ALERTS_ACTIONS.OPEN_ANALYZER
      });
    }
    openLeftPanel({
      id: _panel_keys.DocumentDetailsLeftPanelKey,
      path: {
        tab: _.LeftPanelVisualizeTab,
        subTab: optionId
      },
      params: {
        id: eventId,
        indexName,
        scopeId
      }
    });
  }, [startTransaction, eventId, indexName, scopeId, openLeftPanel]);
  (0, _react.useEffect)(() => {
    var _panels$left2, _panels$left2$path;
    if ((_panels$left2 = panels.left) !== null && _panels$left2 !== void 0 && (_panels$left2$path = _panels$left2.path) !== null && _panels$left2$path !== void 0 && _panels$left2$path.subTab) {
      var _panels$left3, _panels$left3$path;
      setActiveVisualizationId((_panels$left3 = panels.left) === null || _panels$left3 === void 0 ? void 0 : (_panels$left3$path = _panels$left3.path) === null || _panels$left3$path === void 0 ? void 0 : _panels$left3$path.subTab);
    }
  }, [(_panels$left4 = panels.left) === null || _panels$left4 === void 0 ? void 0 : (_panels$left4$path = _panels$left4.path) === null || _panels$left4$path === void 0 ? void 0 : _panels$left4$path.subTab]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    color: "primary",
    name: "coarsness",
    legend: _i18n.i18n.translate('xpack.securitySolution.flyout.left.visualize.buttonGroupLegendLabel', {
      defaultMessage: 'Visualize options'
    }),
    options: visualizeButtons,
    idSelected: activeVisualizationId,
    onChange: id => onChangeCompressed(id),
    buttonSize: "compressed",
    isFullWidth: true,
    "data-test-subj": _test_ids.VISUALIZE_TAB_BUTTON_GROUP_TEST_ID
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), activeVisualizationId === _session_view.SESSION_VIEW_ID && /*#__PURE__*/_react.default.createElement(_session_view.SessionView, null), activeVisualizationId === _analyze_graph.ANALYZE_GRAPH_ID && /*#__PURE__*/_react.default.createElement(_analyze_graph.AnalyzeGraph, null));
});
VisualizeTab.displayName = 'VisualizeTab';