"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SessionView = exports.SESSION_VIEW_ID = void 0;
var _react = _interopRequireDefault(require("react"));
var _field_names = require("../../shared/constants/field_names");
var _utils = require("../../shared/utils");
var _test_ids = require("./test_ids");
var _kibana = require("../../../../common/lib/kibana");
var _context = require("../context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SESSION_VIEW_ID = exports.SESSION_VIEW_ID = 'session-view';

/**
 * Session view displayed in the document details expandable flyout left section under the Visualize tab
 */
const SessionView = () => {
  const {
    sessionView
  } = (0, _kibana.useKibana)().services;
  const {
    getFieldsData,
    indexName
  } = (0, _context.useLeftPanelContext)();
  const ancestorIndex = (0, _utils.getField)(getFieldsData(_field_names.ANCESTOR_INDEX)); // e.g in case of alert, we want to grab it's origin index
  const sessionEntityId = (0, _utils.getField)(getFieldsData(_field_names.ENTRY_LEADER_ENTITY_ID)) || '';
  const sessionStartTime = (0, _utils.getField)(getFieldsData(_field_names.ENTRY_LEADER_START)) || '';
  const index = ancestorIndex || indexName;

  // TODO as part of https://github.com/elastic/security-team/issues/7031
  //  bring back no data message if needed

  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_ids.SESSION_VIEW_TEST_ID
  }, sessionView.getSessionView({
    index,
    sessionEntityId,
    sessionStartTime,
    isFullScreen: true
  }));
};
exports.SessionView = SessionView;
SessionView.displayName = 'SessionView';