"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrevalenceDetails = exports.PREVALENCE_TAB_ID = exports.LicenseProtectedCell = void 0;
var _datemath = _interopRequireDefault(require("@elastic/datemath"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _formatted_number = require("../../../../common/components/formatted_number");
var _use_license = require("../../../../common/hooks/use_license");
var _investigate_in_timeline_button = require("../../../../common/components/event_details/table/investigate_in_timeline_button");
var _use_prevalence = require("../../shared/hooks/use_prevalence");
var _test_ids = require("./test_ids");
var _context = require("../context");
var _use_action_cell_data_provider = require("../../../../common/components/event_details/table/use_action_cell_data_provider");
var _empty_value = require("../../../../common/components/empty_value");
var _types = require("../../../../../common/types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PREVALENCE_TAB_ID = exports.PREVALENCE_TAB_ID = 'prevalence';
const DEFAULT_FROM = 'now-30d';
const DEFAULT_TO = 'now';

/**
 * Component that renders a grey box to indicate the user doesn't have proper license to view the actual data
 */
const LicenseProtectedCell = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_ids.PREVALENCE_DETAILS_TABLE_UPSELL_CELL_TEST_ID,
    style: {
      height: '16px',
      width: '100%',
      background: euiTheme.colors.lightShade
    }
  });
};
exports.LicenseProtectedCell = LicenseProtectedCell;
const columns = [{
  field: 'field',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.prevalence.fieldColumnLabel",
    defaultMessage: "Field"
  }),
  'data-test-subj': _test_ids.PREVALENCE_DETAILS_TABLE_FIELD_CELL_TEST_ID,
  render: field => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, field),
  width: '20%'
}, {
  field: 'values',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.prevalence.valueColumnLabel",
    defaultMessage: "Value"
  }),
  'data-test-subj': _test_ids.PREVALENCE_DETAILS_TABLE_VALUE_CELL_TEST_ID,
  render: values => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, values.map(value => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: value
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, value)))),
  width: '20%'
}, {
  name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.left.insights.prevalence.alertCountColumnTooltip",
      defaultMessage: "Total number of alerts with identical field value pairs."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.prevalence.alertCountColumnLabel",
    defaultMessage: "Alert"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.prevalence.alertCountColumnCountLabel",
    defaultMessage: "count"
  })))),
  'data-test-subj': _test_ids.PREVALENCE_DETAILS_TABLE_ALERT_COUNT_CELL_TEST_ID,
  render: data => {
    const dataProviders = data.values.map(value => (0, _use_action_cell_data_provider.getDataProvider)(data.field, `timeline-indicator-${data.field}-${value}`, value));
    return data.alertCount > 0 ? /*#__PURE__*/_react.default.createElement(_investigate_in_timeline_button.InvestigateInTimelineButton, {
      asEmptyButton: true,
      dataProviders: dataProviders,
      filters: [],
      timeRange: {
        kind: 'absolute',
        from: data.from,
        to: data.to
      }
    }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
      count: data.alertCount
    })) : (0, _empty_value.getEmptyTagValue)();
  },
  width: '10%'
}, {
  name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.left.insights.prevalence.documentCountColumnTooltip",
      defaultMessage: "Total number of event documents with identical field value pairs."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.prevalence.documentCountColumnLabel",
    defaultMessage: "Document"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.prevalence.documentCountColumnCountLabel",
    defaultMessage: "count"
  })))),
  'data-test-subj': _test_ids.PREVALENCE_DETAILS_TABLE_DOC_COUNT_CELL_TEST_ID,
  render: data => {
    const dataProviders = data.values.map(value => ({
      ...(0, _use_action_cell_data_provider.getDataProvider)(data.field, `timeline-indicator-${data.field}-${value}`, value),
      and: [(0, _use_action_cell_data_provider.getDataProviderAnd)('event.kind', `timeline-indicator-event.kind-not-signal`, 'signal', _types.IS_OPERATOR, true)]
    }));
    return data.docCount > 0 ? /*#__PURE__*/_react.default.createElement(_investigate_in_timeline_button.InvestigateInTimelineButton, {
      asEmptyButton: true,
      dataProviders: dataProviders,
      filters: [],
      timeRange: {
        kind: 'absolute',
        from: data.from,
        to: data.to
      },
      keepDataView: true // changing dataview from only detections to include non-alerts docs
    }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
      count: data.docCount
    })) : (0, _empty_value.getEmptyTagValue)();
  },
  width: '10%'
}, {
  name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.left.insights.prevalence.hostPrevalenceColumnTooltip",
      defaultMessage: "Percentage of unique hosts with identical field value pairs."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.prevalence.hostPrevalenceColumnLabel",
    defaultMessage: "Host"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.prevalence.hostPrevalenceColumnCountLabel",
    defaultMessage: "prevalence"
  })))),
  'data-test-subj': _test_ids.PREVALENCE_DETAILS_TABLE_HOST_PREVALENCE_CELL_TEST_ID,
  render: data => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, data.isPlatinumPlus ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, `${Math.round(data.hostPrevalence * 100)}%`) : /*#__PURE__*/_react.default.createElement(LicenseProtectedCell, null)),
  width: '10%'
}, {
  name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.left.insights.prevalence.userPrevalenceColumnTooltip",
      defaultMessage: "Percentage of unique users with identical field value pairs."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.prevalence.userPrevalenceColumnLabel",
    defaultMessage: "User"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.prevalence.userPrevalenceColumnCountLabel",
    defaultMessage: "prevalence"
  })))),
  'data-test-subj': _test_ids.PREVALENCE_DETAILS_TABLE_USER_PREVALENCE_CELL_TEST_ID,
  render: data => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, data.isPlatinumPlus ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, `${Math.round(data.userPrevalence * 100)}%`) : /*#__PURE__*/_react.default.createElement(LicenseProtectedCell, null)),
  width: '10%'
}];

/**
 * Prevalence table displayed in the document details expandable flyout left section under the Insights tab
 */
const PrevalenceDetails = () => {
  const {
    dataFormattedForFieldBrowser,
    investigationFields
  } = (0, _context.useLeftPanelContext)();
  const isPlatinumPlus = (0, _use_license.useLicense)().isPlatinumPlus();

  // these two are used by the usePrevalence hook to fetch the data
  const [start, setStart] = (0, _react.useState)(DEFAULT_FROM);
  const [end, setEnd] = (0, _react.useState)(DEFAULT_TO);

  // these two are used to pass to timeline
  const [absoluteStart, setAbsoluteStart] = (0, _react.useState)((_datemath.default.parse(DEFAULT_FROM) || new Date()).toISOString());
  const [absoluteEnd, setAbsoluteEnd] = (0, _react.useState)((_datemath.default.parse(DEFAULT_TO) || new Date()).toISOString());

  // TODO update the logic to use a single set of start/end dates
  //  currently as we're using this InvestigateInTimelineButton component we need to pass the timeRange
  //  as an AbsoluteTimeRange, which requires from/to values
  const onTimeChange = ({
    start: s,
    end: e,
    isInvalid
  }) => {
    if (isInvalid) return;
    setStart(s);
    setEnd(e);
    const from = _datemath.default.parse(s);
    if (from && from.isValid()) {
      setAbsoluteStart(from.toISOString());
    }
    const to = _datemath.default.parse(e);
    if (to && to.isValid()) {
      setAbsoluteEnd(to.toISOString());
    }
  };
  const {
    loading,
    error,
    data
  } = (0, _use_prevalence.usePrevalence)({
    dataFormattedForFieldBrowser,
    investigationFields,
    interval: {
      from: start,
      to: end
    }
  });

  // add timeRange to pass it down to timeline and license to drive the rendering of the last 2 prevalence columns
  const items = (0, _react.useMemo)(() => data.map(item => ({
    ...item,
    from: absoluteStart,
    to: absoluteEnd,
    isPlatinumPlus
  })), [data, absoluteStart, absoluteEnd, isPlatinumPlus]);
  const upsell = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": _test_ids.PREVALENCE_DETAILS_UPSELL_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.prevalence.tableAlertUpsellDescription",
    defaultMessage: "Host and user prevalence are only available with a {subscription}.",
    values: {
      subscription: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://www.elastic.co/pricing/",
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.left.insights.prevalence.tableAlertUpsellLinkText",
        defaultMessage: "Platinum or higher subscription"
      }))
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !error && !isPlatinumPlus && upsell, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    start: start,
    end: end,
    onTimeChange: onTimeChange,
    "data-test-subj": _test_ids.PREVALENCE_DETAILS_DATE_PICKER_TEST_ID,
    width: "full"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: error ? [] : items,
    columns: columns,
    loading: loading,
    "data-test-subj": _test_ids.PREVALENCE_DETAILS_TABLE_TEST_ID,
    message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.left.insights.prevalence.noDataDescription",
      defaultMessage: "No prevalence data available."
    })
  })));
};
exports.PrevalenceDetails = PrevalenceDetails;
PrevalenceDetails.displayName = 'PrevalenceDetails';