"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PanelContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _panel_keys = require("../shared/constants/panel_keys");
var _helpers = require("../../../timelines/components/side_panel/event_details/helpers");
var _host_isolation = require("../../../common/components/endpoint/host_isolation");
var _use_host_isolation_tools = require("../../../timelines/components/side_panel/event_details/use_host_isolation_tools");
var _context = require("./context");
var _host_isolation2 = require("../../../detections/components/host_isolation");
var _flyout_body = require("../../shared/components/flyout_body");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Document details expandable flyout section content for the isolate host component, displaying the form or the success banner
 */
const PanelContent = () => {
  const {
    openRightPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const {
    dataFormattedForFieldBrowser,
    eventId,
    scopeId,
    indexName,
    isolateAction
  } = (0, _context.useIsolateHostPanelContext)();
  const {
    isIsolateActionSuccessBannerVisible,
    handleIsolationActionSuccess
  } = (0, _use_host_isolation_tools.useHostIsolationTools)();
  const {
    alertId,
    hostName
  } = (0, _helpers.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  const showAlertDetails = (0, _react.useCallback)(() => openRightPanel({
    id: _panel_keys.DocumentDetailsRightPanelKey,
    params: {
      id: eventId,
      indexName,
      scopeId
    }
  }), [eventId, indexName, scopeId, openRightPanel]);
  return /*#__PURE__*/_react.default.createElement(_flyout_body.FlyoutBody, null, isIsolateActionSuccessBannerVisible && /*#__PURE__*/_react.default.createElement(_host_isolation.EndpointIsolateSuccess, {
    hostName: hostName,
    alertId: alertId,
    isolateAction: isolateAction
  }), /*#__PURE__*/_react.default.createElement(_host_isolation2.HostIsolationPanel, {
    details: dataFormattedForFieldBrowser,
    cancelCallback: showAlertDetails,
    successCallback: handleIsolationActionSuccess,
    isolateAction: isolateAction
  }));
};
exports.PanelContent = PanelContent;