"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Users = void 0;
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/timelines-plugin/public");
var _common = require("@kbn/data-plugin/common");
var _constants = require("../../../common/store/inputs/constants");
var _types = require("../../../app/types");
var _filters_global = require("../../../common/components/filters_global");
var _header_page = require("../../../common/components/header_page");
var _tab_navigation = require("../../../common/components/navigation/tab_navigation");
var _search_bar = require("../../../common/components/search_bar");
var _page_wrapper = require("../../../common/components/page_wrapper");
var _last_event_time = require("../../../common/components/last_event_time");
var _use_full_screen = require("../../../common/containers/use_full_screen");
var _use_global_time = require("../../../common/containers/use_global_time");
var _kibana = require("../../../common/lib/kibana");
var _kuery = require("../../../common/lib/kuery");
var _store = require("../../../common/store");
var _spy_routes = require("../../../common/utils/route/spy_routes");
var _users_tabs = require("./users_tabs");
var _nav_tabs = require("./nav_tabs");
var i18n = _interopRequireWildcard(require("./translations"));
var _store2 = require("../store");
var _helpers = require("../../../timelines/components/timeline/helpers");
var _sourcerer = require("../../../common/containers/sourcerer");
var _use_selector = require("../../../common/hooks/use_selector");
var _use_invalid_filter_query = require("../../../common/hooks/use_invalid_filter_query");
var _kpi_users = require("../components/kpi_users");
var _search_strategy = require("../../../../common/search_strategy");
var _helpers2 = require("../../hosts/store/helpers");
var _model = require("../store/model");
var _has_ml_user_permissions = require("../../../../common/machine_learning/has_ml_user_permissions");
var _use_ml_capabilities = require("../../../common/components/ml/hooks/use_ml_capabilities");
var _empty_prompt = require("../../../common/components/empty_prompt");
var _helpers3 = require("./details/helpers");
var _helper_hooks = require("../../../helper_hooks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ID = 'UsersQueryId';

/**
 * Need a 100% height here to account for the graph/analyze tool, which sets no explicit height parameters, but fills the available space.
 */
const StyledFullHeightContainer = _styledComponents.default.div`
  display: flex;
  flex-direction: column;
  flex: 1 1 auto;
`;
const UsersComponent = () => {
  const containerElement = (0, _react.useRef)(null);
  const getGlobalFiltersQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalFiltersQuerySelector(), []);
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalQuerySelector(), []);
  const query = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const globalFilters = (0, _use_selector.useDeepEqualSelector)(getGlobalFiltersQuerySelector);
  const getUserRiskScoreFilterQuerySelector = (0, _react.useMemo)(() => _store2.usersSelectors.userRiskScoreSeverityFilterSelector(), []);
  const severitySelection = (0, _use_selector.useDeepEqualSelector)(state => getUserRiskScoreFilterQuerySelector(state));
  const {
    to,
    from,
    deleteQuery,
    setQuery,
    isInitializing
  } = (0, _use_global_time.useGlobalTime)();
  const {
    globalFullScreen
  } = (0, _use_full_screen.useGlobalFullScreen)();
  const {
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const {
    tabName
  } = (0, _reactRouterDom.useParams)();
  const tabsFilters = _react.default.useMemo(() => {
    if (tabName === _model.UsersTableType.events) {
      return [...globalFilters, ..._helpers3.userNameExistsFilter];
    }
    if (tabName === _model.UsersTableType.risk) {
      const severityFilter = (0, _helpers2.generateSeverityFilter)(severitySelection, _search_strategy.RiskScoreEntity.user);
      return [...severityFilter, ...globalFilters];
    }
    return globalFilters;
  }, [severitySelection, tabName, globalFilters]);
  const {
    indicesExist,
    indexPattern,
    selectedPatterns,
    sourcererDataView
  } = (0, _sourcerer.useSourcererDataView)();
  const [globalFiltersQuery, kqlError] = (0, _react.useMemo)(() => (0, _kuery.convertToBuildEsQuery)({
    config: (0, _common.getEsQueryConfig)(uiSettings),
    indexPattern,
    queries: [query],
    filters: globalFilters
  }), [globalFilters, indexPattern, uiSettings, query]);
  const [tabsFilterQuery] = (0, _react.useMemo)(() => (0, _kuery.convertToBuildEsQuery)({
    config: (0, _common.getEsQueryConfig)(uiSettings),
    indexPattern,
    queries: [query],
    filters: tabsFilters
  }), [indexPattern, query, tabsFilters, uiSettings]);
  (0, _use_invalid_filter_query.useInvalidFilterQuery)({
    id: ID,
    filterQuery: globalFiltersQuery,
    kqlError,
    query,
    startDate: from,
    endDate: to
  });
  const onSkipFocusBeforeEventsTable = (0, _react.useCallback)(() => {
    var _containerElement$cur, _containerElement$cur2;
    (_containerElement$cur = containerElement.current) === null || _containerElement$cur === void 0 ? void 0 : (_containerElement$cur2 = _containerElement$cur.querySelector('.inspectButtonComponent:last-of-type')) === null || _containerElement$cur2 === void 0 ? void 0 : _containerElement$cur2.focus();
  }, [containerElement]);
  const onSkipFocusAfterEventsTable = (0, _react.useCallback)(() => {
    (0, _helpers.resetKeyboardFocus)();
  }, []);
  const onKeyDown = (0, _react.useCallback)(keyboardEvent => {
    if ((0, _public.isTab)(keyboardEvent)) {
      (0, _helpers.onTimelineTabKeyPressed)({
        containerElement: containerElement.current,
        keyboardEvent,
        onSkipFocusBeforeEventsTable,
        onSkipFocusAfterEventsTable
      });
    }
  }, [containerElement, onSkipFocusBeforeEventsTable, onSkipFocusAfterEventsTable]);
  const capabilities = (0, _use_ml_capabilities.useMlCapabilities)();
  const hasEntityAnalyticsCapability = (0, _helper_hooks.useHasSecurityCapability)('entity-analytics');
  const navTabs = (0, _react.useMemo)(() => (0, _nav_tabs.navTabsUsers)((0, _has_ml_user_permissions.hasMlUserPermissions)(capabilities), hasEntityAnalyticsCapability), [capabilities, hasEntityAnalyticsCapability]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, indicesExist ? /*#__PURE__*/_react.default.createElement(StyledFullHeightContainer, {
    onKeyDown: onKeyDown,
    ref: containerElement
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiWindowEvent, {
    event: "resize",
    handler: _fp.noop
  }), /*#__PURE__*/_react.default.createElement(_filters_global.FiltersGlobal, null, /*#__PURE__*/_react.default.createElement(_search_bar.SiemSearchBar, {
    sourcererDataView: sourcererDataView,
    id: _constants.InputsModelId.global
  })), /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    noPadding: globalFullScreen
  }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    subtitle: /*#__PURE__*/_react.default.createElement(_last_event_time.LastEventTime, {
      indexKey: _search_strategy.LastEventIndexKey.users,
      indexNames: selectedPatterns
    }),
    border: true,
    title: i18n.PAGE_TITLE
  }), /*#__PURE__*/_react.default.createElement(_kpi_users.UsersKpiComponent, {
    from: from,
    to: to
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_tab_navigation.TabNavigation, {
    navTabs: navTabs
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_users_tabs.UsersTabs, {
    deleteQuery: deleteQuery,
    filterQuery: tabsFilterQuery,
    from: from,
    indexNames: selectedPatterns,
    isInitializing: isInitializing,
    setQuery: setQuery,
    to: to,
    type: _store2.usersModel.UsersType.page
  }))) : /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, null), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.users
  }));
};
UsersComponent.displayName = 'UsersComponent';
const Users = exports.Users = /*#__PURE__*/_react.default.memo(UsersComponent);