"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTrailingBreadcrumbs = void 0;
var _fp = require("lodash/fp");
var _model = require("../../store/model");
var _redirect_to_users = require("../../../../common/components/link_to/redirect_to_users");
var i18n = _interopRequireWildcard(require("../translations"));
var _types = require("../../../../app/types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TabNameMappedToI18nKey = {
  [_model.UsersTableType.allUsers]: i18n.NAVIGATION_ALL_USERS_TITLE,
  [_model.UsersTableType.authentications]: i18n.NAVIGATION_AUTHENTICATIONS_TITLE,
  [_model.UsersTableType.anomalies]: i18n.NAVIGATION_ANOMALIES_TITLE,
  [_model.UsersTableType.risk]: i18n.NAVIGATION_RISK_TITLE,
  [_model.UsersTableType.events]: i18n.NAVIGATION_EVENTS_TITLE,
  [_model.UsersTableType.risk]: i18n.NAVIGATION_RISK_TITLE
};

/**
 * This module should only export this function.
 * All the `getTrailingBreadcrumbs` functions in Security are loaded into the main bundle.
 * We should be careful to not import unnecessary modules in this file to avoid increasing the main app bundle size.
 */
const getTrailingBreadcrumbs = (params, getSecuritySolutionUrl) => {
  let breadcrumb = [];
  if (params.detailName != null) {
    breadcrumb = [{
      text: params.detailName,
      href: getSecuritySolutionUrl({
        path: (0, _redirect_to_users.getUsersDetailsUrl)(params.detailName, ''),
        deepLinkId: _types.SecurityPageName.users
      })
    }];
  }
  if (params.tabName != null) {
    const tabName = (0, _fp.get)('tabName', params);
    if (!tabName) return breadcrumb;
    breadcrumb = [...breadcrumb, {
      text: TabNameMappedToI18nKey[tabName],
      href: ''
    }];
  }
  return breadcrumb;
};
exports.getTrailingBreadcrumbs = getTrailingBreadcrumbs;