"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useObservedUserDetails = exports.OBSERVED_USER_QUERY_ID = void 0;
var _react = require("react");
var i18n = _interopRequireWildcard(require("./translations"));
var _users = require("../../../../../../common/search_strategy/security_solution/users");
var _common = require("../../../../../../common/search_strategy/security_solution/users/common");
var _use_search_strategy = require("../../../../../common/containers/use_search_strategy");
var _use_experimental_features = require("../../../../../common/hooks/use_experimental_features");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OBSERVED_USER_QUERY_ID = exports.OBSERVED_USER_QUERY_ID = 'observedUsersDetailsQuery';
const useObservedUserDetails = ({
  endDate,
  userName,
  indexNames,
  id = OBSERVED_USER_QUERY_ID,
  skip = false,
  startDate
}) => {
  const isNewUserDetailsFlyoutEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newUserDetailsFlyout');
  const {
    loading,
    result: response,
    search,
    refetch,
    inspect
  } = (0, _use_search_strategy.useSearchStrategy)({
    factoryQueryType: _users.UsersQueries.observedDetails,
    initialResult: {
      userDetails: {}
    },
    errorMessage: i18n.FAIL_USER_DETAILS,
    abort: skip
  });
  const userDetailsResponse = (0, _react.useMemo)(() => ({
    endDate,
    userDetails: response.userDetails,
    id,
    inspect,
    refetch,
    startDate
  }), [endDate, id, inspect, refetch, response.userDetails, startDate]);
  const userDetailsRequest = (0, _react.useMemo)(() => ({
    defaultIndex: indexNames,
    factoryQueryType: _users.UsersQueries.observedDetails,
    userName,
    timerange: {
      interval: '12h',
      from: startDate,
      to: endDate
    },
    filterQuery: isNewUserDetailsFlyoutEnabled ? _common.NOT_EVENT_KIND_ASSET_FILTER : undefined
  }), [endDate, indexNames, startDate, userName, isNewUserDetailsFlyoutEnabled]);
  (0, _react.useEffect)(() => {
    if (!skip) {
      search(userDetailsRequest);
    }
  }, [userDetailsRequest, search, skip]);
  return [loading, userDetailsResponse];
};
exports.useObservedUserDetails = useObservedUserDetails;