"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.routes = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/usage-collection-plugin/public");
var _pages = require("./users/pages");
var _pages2 = require("./hosts/pages");
var _pages3 = require("./network/pages");
var _types = require("../app/types");
var _constants = require("../../common/constants");
var _plugin_template_wrapper = require("../common/components/plugin_template_wrapper");
var _landing = require("./landing");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExploreLanding = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, null, /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
  viewId: _types.SecurityPageName.exploreLanding
}, /*#__PURE__*/_react.default.createElement(_landing.ExploreLandingPage, null)));
const NetworkRoutes = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, null, /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
  viewId: _types.SecurityPageName.network
}, /*#__PURE__*/_react.default.createElement(_pages3.NetworkContainer, null)));
const UsersRoutes = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, null, /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
  viewId: _types.SecurityPageName.users
}, /*#__PURE__*/_react.default.createElement(_pages.UsersContainer, null)));
const HostsRoutes = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, null, /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
  viewId: _types.SecurityPageName.hosts
}, /*#__PURE__*/_react.default.createElement(_pages2.HostsContainer, null)));
const routes = exports.routes = [{
  path: _constants.EXPLORE_PATH,
  exact: true,
  component: ExploreLanding
}, {
  path: _constants.NETWORK_PATH,
  component: NetworkRoutes
}, {
  path: _constants.USERS_PATH,
  component: UsersRoutes
}, {
  path: _constants.HOSTS_PATH,
  component: HostsRoutes
}];