"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceDestinationArrows = exports.SOURCE_PACKETS_FIELD_NAME = exports.SOURCE_BYTES_FIELD_NAME = exports.DESTINATION_PACKETS_FIELD_NAME = exports.DESTINATION_BYTES_FIELD_NAME = void 0;
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _arrows = require("../arrows");
var _helpers = require("../arrows/helpers");
var _draggables = require("../../../../common/components/draggables");
var _formatted_bytes = require("../../../../common/components/formatted_bytes");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SOURCE_BYTES_FIELD_NAME = exports.SOURCE_BYTES_FIELD_NAME = 'source.bytes';
const SOURCE_PACKETS_FIELD_NAME = exports.SOURCE_PACKETS_FIELD_NAME = 'source.packets';
const DESTINATION_BYTES_FIELD_NAME = exports.DESTINATION_BYTES_FIELD_NAME = 'destination.bytes';
const DESTINATION_PACKETS_FIELD_NAME = exports.DESTINATION_PACKETS_FIELD_NAME = 'destination.packets';
const Percent = _styledComponents.default.span`
  margin-right: 5px;
`;
Percent.displayName = 'Percent';
const SourceDestinationArrowsContainer = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  margin: 0 2px;

  .euiToolTipAnchor {
    white-space: nowrap;
  }
`;
SourceDestinationArrowsContainer.displayName = 'SourceDestinationArrowsContainer';
const Data = (0, _styledComponents.default)(_eui.EuiText)`
  margin: 0 5px;
`;
Data.displayName = 'Data';

/**
 * Visualizes the communication from a source as an arrow with draggable badges
 */
const SourceArrow = /*#__PURE__*/_react.default.memo(({
  contextId,
  eventId,
  isDraggable,
  sourceBytes,
  sourceBytesPercent,
  sourcePackets
}) => {
  const sourceArrowHeight = sourceBytesPercent != null ? (0, _helpers.getArrowHeightFromPercent)(sourceBytesPercent) : _helpers.DEFAULT_ARROW_HEIGHT;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_arrows.ArrowBody, {
    height: sourceArrowHeight !== null && sourceArrowHeight !== void 0 ? sourceArrowHeight : 0
  })), sourceBytes != null && !isNaN(Number(sourceBytes)) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
    field: SOURCE_BYTES_FIELD_NAME,
    id: `source-arrow-default-draggable-${contextId}-${eventId}-${SOURCE_BYTES_FIELD_NAME}-${sourceBytes}`,
    isDraggable: isDraggable,
    value: sourceBytes
  }, /*#__PURE__*/_react.default.createElement(Data, {
    size: "xs"
  }, sourceBytesPercent != null ? /*#__PURE__*/_react.default.createElement(Percent, null, `(${(0, _numeral.default)(sourceBytesPercent).format('0.00')}%)`) : null, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_formatted_bytes.PreferenceFormattedBytes, {
    value: sourceBytes
  }))))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_arrows.ArrowBody, {
    height: sourceArrowHeight !== null && sourceArrowHeight !== void 0 ? sourceArrowHeight : 0
  })), sourcePackets != null && !isNaN(Number(sourcePackets)) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
    field: SOURCE_PACKETS_FIELD_NAME,
    id: `source-arrow-default-draggable-${contextId}-${eventId}-${SOURCE_PACKETS_FIELD_NAME}-${sourcePackets}`,
    isDraggable: isDraggable,
    value: sourcePackets
  }, /*#__PURE__*/_react.default.createElement(Data, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("span", null, `${sourcePackets} ${i18n.PACKETS}`)))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_arrows.ArrowBody, {
    height: sourceArrowHeight !== null && sourceArrowHeight !== void 0 ? sourceArrowHeight : 0
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_arrows.ArrowHead, {
    direction: "arrowRight"
  })));
});
SourceArrow.displayName = 'SourceArrow';

/**
 * Visualizes the communication from a destination as an arrow with draggable
 * badges
 */
const DestinationArrow = /*#__PURE__*/_react.default.memo(({
  contextId,
  destinationBytes,
  destinationBytesPercent,
  destinationPackets,
  eventId,
  isDraggable
}) => {
  const destinationArrowHeight = destinationBytesPercent != null ? (0, _helpers.getArrowHeightFromPercent)(destinationBytesPercent) : _helpers.DEFAULT_ARROW_HEIGHT;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_arrows.ArrowHead, {
    direction: "arrowLeft"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_arrows.ArrowBody, {
    height: destinationArrowHeight !== null && destinationArrowHeight !== void 0 ? destinationArrowHeight : 0
  })), destinationBytes != null && !isNaN(Number(destinationBytes)) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
    field: DESTINATION_BYTES_FIELD_NAME,
    id: `destination-arrow-default-draggable-${contextId}-${eventId}-${DESTINATION_BYTES_FIELD_NAME}-${destinationBytes}`,
    isDraggable: isDraggable,
    value: destinationBytes
  }, /*#__PURE__*/_react.default.createElement(Data, {
    size: "xs"
  }, destinationBytesPercent != null ? /*#__PURE__*/_react.default.createElement(Percent, null, `(${(0, _numeral.default)(destinationBytesPercent).format('0.00')}%)`) : null, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_formatted_bytes.PreferenceFormattedBytes, {
    value: destinationBytes
  }))))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_arrows.ArrowBody, {
    height: destinationArrowHeight !== null && destinationArrowHeight !== void 0 ? destinationArrowHeight : 0
  })), destinationPackets != null && !isNaN(Number(destinationPackets)) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
    field: DESTINATION_PACKETS_FIELD_NAME,
    id: `destination-arrow-default-draggable-${contextId}-${eventId}-${DESTINATION_PACKETS_FIELD_NAME}-${destinationPackets}`,
    isDraggable: isDraggable,
    value: destinationPackets
  }, /*#__PURE__*/_react.default.createElement(Data, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("span", null, `${(0, _numeral.default)(destinationPackets).format('0,0')} ${i18n.PACKETS}`)))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_arrows.ArrowBody, {
    height: destinationArrowHeight !== null && destinationArrowHeight !== void 0 ? destinationArrowHeight : 0
  })));
});
DestinationArrow.displayName = 'DestinationArrow';

/**
 * Visualizes the communication between a source and a destination using arrows
 * that grow in thickness based on the percentage of bytes transferred, and stats badges
 */
const SourceDestinationArrows = exports.SourceDestinationArrows = /*#__PURE__*/_react.default.memo(({
  contextId,
  destinationBytes,
  destinationPackets,
  eventId,
  isDraggable,
  sourceBytes,
  sourcePackets
}) => {
  const maybeSourceBytes = sourceBytes != null && (0, _helpers.hasOneValue)(sourceBytes) ? sourceBytes[0] : undefined;
  const maybeSourcePackets = sourcePackets != null && (0, _helpers.hasOneValue)(sourcePackets) ? sourcePackets[0] : undefined;
  const maybeDestinationBytes = destinationBytes != null && (0, _helpers.hasOneValue)(destinationBytes) ? destinationBytes[0] : undefined;
  const maybeDestinationPackets = destinationPackets != null && (0, _helpers.hasOneValue)(destinationPackets) ? destinationPackets[0] : undefined;
  const maybeSourceBytesPercent = maybeSourceBytes != null && maybeDestinationBytes != null ? (0, _helpers.getPercent)({
    numerator: Number(maybeSourceBytes),
    denominator: Number(maybeSourceBytes) + Number(maybeDestinationBytes)
  }) : undefined;
  const maybeDestinationBytesPercent = maybeSourceBytesPercent != null ? 100 - maybeSourceBytesPercent : undefined;
  return /*#__PURE__*/_react.default.createElement(SourceDestinationArrowsContainer, {
    alignItems: "center",
    justifyContent: "center",
    direction: "column",
    gutterSize: "none"
  }, maybeSourceBytes != null ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(SourceArrow, {
    contextId: contextId,
    eventId: eventId,
    isDraggable: isDraggable,
    sourceBytes: maybeSourceBytes,
    sourcePackets: maybeSourcePackets,
    sourceBytesPercent: maybeSourceBytesPercent
  })) : null, maybeDestinationBytes != null ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(DestinationArrow, {
    contextId: contextId,
    destinationBytes: maybeDestinationBytes,
    destinationPackets: maybeDestinationPackets,
    destinationBytesPercent: maybeDestinationBytesPercent,
    eventId: eventId,
    isDraggable: isDraggable
  })) : null);
});
SourceDestinationArrows.displayName = 'SourceDestinationArrows';