"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToolTipFooterComponent = exports.ToolTipFooter = exports.Icon = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Icon = exports.Icon = (0, _styledComponents.default)(_eui.EuiIcon)`
  margin-right: ${_uiTheme.euiLightVars.euiSizeS};
`;
Icon.displayName = 'Icon';
const ToolTipFooterComponent = ({
  featureIndex,
  totalFeatures,
  previousFeature,
  nextFeature
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, i18n.MAP_TOOL_TIP_FEATURES_FOOTER(featureIndex + 1, totalFeatures))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": 'previous-feature-button',
    color: 'text',
    onClick: previousFeature,
    iconType: "arrowLeft",
    "aria-label": "Next",
    isDisabled: featureIndex <= 0
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": 'next-feature-button',
    color: 'text',
    onClick: nextFeature,
    iconType: "arrowRight",
    "aria-label": "Next",
    isDisabled: featureIndex >= totalFeatures - 1
  })))));
};
exports.ToolTipFooterComponent = ToolTipFooterComponent;
ToolTipFooterComponent.displayName = 'ToolTipFooterComponent';
const ToolTipFooter = exports.ToolTipFooter = /*#__PURE__*/_react.default.memo(ToolTipFooterComponent);
ToolTipFooter.displayName = 'ToolTipFooter';