"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uniqueIpsStatItems = exports.ID = exports.HostsKpiUniqueIps = void 0;
var _react = _interopRequireDefault(require("react"));
var _kpi_unique_ips_area = require("../../../../../common/components/visualization_actions/lens_attributes/hosts/kpi_unique_ips_area");
var _kpi_unique_ips_bar = require("../../../../../common/components/visualization_actions/lens_attributes/hosts/kpi_unique_ips_bar");
var _kpi_unique_ips_destination_metric = require("../../../../../common/components/visualization_actions/lens_attributes/hosts/kpi_unique_ips_destination_metric");
var _kpi_unique_ips_source_metric = require("../../../../../common/components/visualization_actions/lens_attributes/hosts/kpi_unique_ips_source_metric");
var _kpi = require("../../../../components/kpi");
var _types = require("../types");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ID = exports.ID = 'hostsKpiUniqueIpsQuery';
const uniqueIpsStatItems = exports.uniqueIpsStatItems = [{
  key: 'uniqueIps',
  fields: [{
    key: 'uniqueSourceIps',
    name: i18n.SOURCE_CHART_LABEL,
    description: i18n.SOURCE_UNIT_LABEL,
    color: _types.HostsKpiChartColors.uniqueSourceIps,
    icon: 'visMapCoordinate',
    lensAttributes: _kpi_unique_ips_source_metric.kpiUniqueIpsSourceMetricLensAttributes
  }, {
    key: 'uniqueDestinationIps',
    name: i18n.DESTINATION_CHART_LABEL,
    description: i18n.DESTINATION_UNIT_LABEL,
    color: _types.HostsKpiChartColors.uniqueDestinationIps,
    icon: 'visMapCoordinate',
    lensAttributes: _kpi_unique_ips_destination_metric.kpiUniqueIpsDestinationMetricLensAttributes
  }],
  enableAreaChart: true,
  enableBarChart: true,
  description: i18n.UNIQUE_IPS,
  areaChartLensAttributes: _kpi_unique_ips_area.kpiUniqueIpsAreaLensAttributes,
  barChartLensAttributes: _kpi_unique_ips_bar.kpiUniqueIpsBarLensAttributes
}];
const HostsKpiUniqueIpsComponent = ({
  from,
  to
}) => {
  return /*#__PURE__*/_react.default.createElement(_kpi.KpiBaseComponent, {
    from: from,
    id: ID,
    statItems: uniqueIpsStatItems,
    to: to
  });
};
const HostsKpiUniqueIps = exports.HostsKpiUniqueIps = /*#__PURE__*/_react.default.memo(HostsKpiUniqueIpsComponent);