"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VERSION = exports.UNIT = exports.ROWS_5 = exports.ROWS_10 = exports.RISK_SCORE = exports.OS_LAST_SEEN_TOOLTIP = exports.OS = exports.NAME = exports.LAST_SEEN = exports.HOSTS = exports.FIRST_LAST_SEEN_TOOLTIP = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HOSTS = exports.HOSTS = _i18n.i18n.translate('xpack.securitySolution.hostsTable.hostsTitle', {
  defaultMessage: 'All hosts'
});
const UNIT = totalCount => _i18n.i18n.translate('xpack.securitySolution.hostsTable.unit', {
  values: {
    totalCount
  },
  defaultMessage: `{totalCount, plural, =1 {host} other {hosts}}`
});
exports.UNIT = UNIT;
const RISK_SCORE = exports.RISK_SCORE = _i18n.i18n.translate('xpack.securitySolution.hostsRiskTable.tableTitle', {
  defaultMessage: 'Host risk'
});
const NAME = exports.NAME = _i18n.i18n.translate('xpack.securitySolution.hostsTable.nameTitle', {
  defaultMessage: 'Host name'
});
const LAST_SEEN = exports.LAST_SEEN = _i18n.i18n.translate('xpack.securitySolution.hostsTable.lastSeenTitle', {
  defaultMessage: 'Last seen'
});
const FIRST_LAST_SEEN_TOOLTIP = exports.FIRST_LAST_SEEN_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.hostsTable.firstLastSeenToolTip', {
  defaultMessage: 'Relative to the selected date range'
});
const OS_LAST_SEEN_TOOLTIP = exports.OS_LAST_SEEN_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.hostsTable.osLastSeenToolTip', {
  defaultMessage: 'Last observed operating system'
});
const OS = exports.OS = _i18n.i18n.translate('xpack.securitySolution.hostsTable.osTitle', {
  defaultMessage: 'Operating system'
});
const VERSION = exports.VERSION = _i18n.i18n.translate('xpack.securitySolution.hostsTable.versionTitle', {
  defaultMessage: 'Version'
});
const ROWS_5 = exports.ROWS_5 = _i18n.i18n.translate('xpack.securitySolution.hostsTable.rows', {
  values: {
    numRows: 5
  },
  defaultMessage: '{numRows} {numRows, plural, =0 {rows} =1 {row} other {rows}}'
});
const ROWS_10 = exports.ROWS_10 = _i18n.i18n.translate('xpack.securitySolution.hostsTable.rows', {
  values: {
    numRows: 10
  },
  defaultMessage: '{numRows} {numRows, plural, =0 {rows} =1 {row} other {rows}}'
});