"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetCriticalityUploadPage = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _asset_criticality = require("../../../common/entity_analytics/asset_criticality");
var _kibana = require("../../common/lib/kibana");
var _constants = require("../../../common/constants");
var _asset_criticality_file_uploader = require("../components/asset_criticality_file_uploader/asset_criticality_file_uploader");
var _use_asset_criticality = require("../components/asset_criticality/use_asset_criticality");
var _helper_hooks = require("../../helper_hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AssetCriticalityUploadPage = () => {
  const {
    docLinks
  } = (0, _kibana.useKibana)().services;
  const entityAnalyticsLinks = docLinks.links.securitySolution.entityAnalytics;
  const hasEntityAnalyticsCapability = (0, _helper_hooks.useHasSecurityCapability)('entity-analytics');
  const [isAssetCriticalityEnabled] = (0, _kibana.useUiSetting$)(_constants.ENABLE_ASSET_CRITICALITY_SETTING);
  const {
    data: privileges,
    error: privilegesError,
    isLoading
  } = (0, _use_asset_criticality.useAssetCriticalityPrivileges)('AssetCriticalityUploadPage');
  const hasWritePermissions = privileges === null || privileges === void 0 ? void 0 : privileges.has_write_permissions;
  if (isLoading) {
    // Wait for permission before rendering content to avoid flickering
    return null;
  }
  if (!hasEntityAnalyticsCapability || !isAssetCriticalityEnabled || (privilegesError === null || privilegesError === void 0 ? void 0 : privilegesError.body.status_code) === 403) {
    var _privilegesError$body;
    const errorMessage = (_privilegesError$body = privilegesError === null || privilegesError === void 0 ? void 0 : privilegesError.body.message) !== null && _privilegesError$body !== void 0 ? _privilegesError$body : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.advancedSettingDisabledMessage",
      defaultMessage: "Please enable \"{ENABLE_ASSET_CRITICALITY_SETTING}\" on advanced settings to access the page.",
      values: {
        ENABLE_ASSET_CRITICALITY_SETTING: _constants.ENABLE_ASSET_CRITICALITY_SETTING
      }
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "warning",
      title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.advancedSettingDisabledTitle",
        defaultMessage: "This page is disabled"
      })),
      body: /*#__PURE__*/_react.default.createElement("p", null, errorMessage)
    });
  }
  if (!hasWritePermissions) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.noPermissionTitle",
        defaultMessage: "Insufficient index privileges to access this page"
      }),
      color: "primary",
      iconType: "iInCircle"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.missingPermissionsCallout.description",
      defaultMessage: "Write permission is required for the {index} index pattern in order to access this page. Contact your administrator for further assistance.",
      values: {
        index: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, _asset_criticality.ASSET_CRITICALITY_INDEX_PATTERN)
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    "data-test-subj": "assetCriticalityUploadPage",
    pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.title",
      defaultMessage: "Asset criticality"
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.subTitle",
    defaultMessage: "Quickly Assign Asset Criticality with CSV Upload"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.description",
    defaultMessage: "Effortlessly import asset criticality from your asset management tools via CSV. This simple upload ensures data accuracy and reduces manual input errors."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_asset_criticality_file_uploader.AssetCriticalityFileUploader, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "l",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "questionInCircle",
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.information.title",
    defaultMessage: "What is asset criticality?"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.information.description",
    defaultMessage: "Allows you to classify assets based on their value and impact on business operations, to guide prioritization for alert triaging, threat-hunting, and investigation activities."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.information.usefulLinks",
    defaultMessage: "Useful links"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    rel: "noopener nofollow noreferrer",
    href: entityAnalyticsLinks.assetCriticality
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.documentationLink",
    defaultMessage: "Asset criticality documentation"
  }))))));
};
exports.AssetCriticalityUploadPage = AssetCriticalityUploadPage;
AssetCriticalityUploadPage.displayName = 'AssetCriticalityUploadPage';