"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMissingRiskEnginePrivileges = void 0;
var _react = require("react");
var _use_risk_engine_privileges = require("../api/hooks/use_risk_engine_privileges");
var _risk_engine = require("../../../common/entity_analytics/risk_engine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMissingRiskEnginePrivileges = () => {
  const {
    data: privilegesResponse,
    isLoading
  } = (0, _use_risk_engine_privileges.useRiskEnginePrivileges)();
  return (0, _react.useMemo)(() => {
    if (isLoading || !privilegesResponse) {
      return {
        isLoading: true
      };
    }
    if (privilegesResponse.has_all_required) {
      return {
        isLoading: false,
        hasAllRequiredPrivileges: true
      };
    }
    const {
      indexPrivileges,
      clusterPrivileges
    } = (0, _risk_engine.getMissingRiskEnginePrivileges)(privilegesResponse.privileges);
    return {
      isLoading: false,
      hasAllRequiredPrivileges: false,
      missingPrivileges: {
        indexPrivileges,
        clusterPrivileges
      }
    };
  }, [isLoading, privilegesResponse]);
};
exports.useMissingRiskEnginePrivileges = useMissingRiskEnginePrivileges;