"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserRiskScoreQueryTabBody = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _use_risk_score_kpi = require("../api/hooks/use_risk_score_kpi");
var _use_risk_score = require("../api/hooks/use_risk_score");
var _utils = require("../common/utils");
var _enable_risk_score = require("./enable_risk_score");
var _manage_query = require("../../common/components/page/manage_query");
var _use_selector = require("../../common/hooks/use_selector");
var _user_risk_score_table = require("./user_risk_score_table");
var _store = require("../../explore/users/store");
var _query_toggle = require("../../common/containers/query_toggle");
var _search_strategy = require("../../../common/search_strategy");
var _risk_score_no_data_detected = require("./risk_score_onboarding/risk_score_no_data_detected");
var _use_risk_engine_status = require("../api/hooks/use_risk_engine_status");
var _risk_score_update_panel = require("./risk_score_update_panel");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UserRiskScoreTableManage = (0, _manage_query.manageQuery)(_user_risk_score_table.UserRiskScoreTable);
const UserRiskScoreQueryTabBody = ({
  deleteQuery,
  endDate: to,
  filterQuery,
  setQuery,
  skip,
  startDate: from,
  type
}) => {
  const {
    data: riskScoreEngineStatus
  } = (0, _use_risk_engine_status.useRiskEngineStatus)();
  const getUserRiskScoreSelector = (0, _react.useMemo)(() => _store.usersSelectors.userRiskScoreSelector(), []);
  const {
    activePage,
    limit,
    sort
  } = (0, _use_selector.useDeepEqualSelector)(state => getUserRiskScoreSelector(state));
  const getUserRiskScoreFilterQuerySelector = (0, _react.useMemo)(() => _store.usersSelectors.userRiskScoreSeverityFilterSelector(), []);
  const userSeveritySelectionRedux = (0, _use_selector.useDeepEqualSelector)(state => getUserRiskScoreFilterQuerySelector(state));
  const pagination = (0, _react.useMemo)(() => ({
    cursorStart: activePage * limit,
    querySize: limit
  }), [activePage, limit]);
  const {
    toggleStatus
  } = (0, _query_toggle.useQueryToggle)(_utils.UserRiskScoreQueryId.USERS_BY_RISK);
  const [querySkip, setQuerySkip] = (0, _react.useState)(skip || !toggleStatus);
  (0, _react.useEffect)(() => {
    setQuerySkip(skip || !toggleStatus);
  }, [skip, toggleStatus]);
  const timerange = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);
  const {
    data,
    inspect,
    isDeprecated,
    isInspected,
    isModuleEnabled,
    loading,
    refetch,
    totalCount
  } = (0, _use_risk_score.useRiskScore)({
    filterQuery,
    pagination,
    riskEntity: _search_strategy.RiskScoreEntity.user,
    skip: querySkip,
    sort,
    timerange
  });
  const {
    severityCount,
    loading: isKpiLoading
  } = (0, _use_risk_score_kpi.useRiskScoreKpi)({
    filterQuery,
    riskEntity: _search_strategy.RiskScoreEntity.user,
    skip: querySkip
  });
  const status = {
    isDisabled: !isModuleEnabled && !loading,
    isDeprecated: isDeprecated && !loading
  };
  if (status.isDisabled || status.isDeprecated) {
    return /*#__PURE__*/_react.default.createElement(_enable_risk_score.EnableRiskScore, (0, _extends2.default)({}, status, {
      entityType: _search_strategy.RiskScoreEntity.user,
      refetch: refetch,
      timerange: timerange
    }));
  }
  if (isModuleEnabled && userSeveritySelectionRedux.length === 0 && data && data.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_risk_score_no_data_detected.RiskScoresNoDataDetected, {
      entityType: _search_strategy.RiskScoreEntity.user,
      refetch: refetch
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (riskScoreEngineStatus === null || riskScoreEngineStatus === void 0 ? void 0 : riskScoreEngineStatus.isUpdateAvailable) && /*#__PURE__*/_react.default.createElement(_risk_score_update_panel.RiskScoreUpdatePanel, null), /*#__PURE__*/_react.default.createElement(UserRiskScoreTableManage, {
    deleteQuery: deleteQuery,
    data: data !== null && data !== void 0 ? data : [],
    id: _utils.UserRiskScoreQueryId.USERS_BY_RISK,
    inspect: inspect,
    isInspect: isInspected,
    loading: loading || isKpiLoading,
    loadPage: _fp.noop // It isn't necessary because PaginatedTable updates redux store and we load the page when activePage updates on the store
    ,
    refetch: refetch,
    setQuery: setQuery,
    setQuerySkip: setQuerySkip,
    severityCount: severityCount !== null && severityCount !== void 0 ? severityCount : _search_strategy.EMPTY_SEVERITY_COUNT,
    totalCount: totalCount,
    type: type
  }));
};
exports.UserRiskScoreQueryTabBody = UserRiskScoreQueryTabBody;
UserRiskScoreQueryTabBody.displayName = 'UserRiskScoreQueryTabBody';