"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getItems = exports.getEntityData = exports.buildColumns = exports.SUMMARY_TABLE_MIN_WIDTH = exports.LENS_VISUALIZATION_MIN_WIDTH = exports.LENS_VISUALIZATION_HEIGHT = exports.LAST_30_DAYS = void 0;
exports.isUserRiskData = isUserRiskData;
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _fp = require("lodash/fp");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildColumns = showFooter => [{
  field: 'category',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.categoryColumnLabel",
    defaultMessage: "Category"
  }),
  truncateText: false,
  mobileOptions: {
    show: true
  },
  sortable: true,
  footer: showFooter ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.categoryColumnFooterLabel",
    defaultMessage: "Result"
  }) : undefined
}, {
  field: 'score',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.scoreColumnLabel",
    defaultMessage: "Score"
  }),
  truncateText: false,
  mobileOptions: {
    show: true
  },
  sortable: true,
  dataType: 'number',
  align: 'right',
  render: _common.formatRiskScore,
  footer: props => showFooter ? /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "risk-summary-result-score"
  }, (0, _common.formatRiskScore)((0, _fp.sumBy)(i => i.score, props.items))) : undefined
}, {
  field: 'count',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.inputsColumnLabel",
    defaultMessage: "Inputs"
  }),
  truncateText: false,
  mobileOptions: {
    show: true
  },
  sortable: true,
  dataType: 'number',
  align: 'right',
  footer: props => showFooter ? /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "risk-summary-result-count"
  }, (0, _fp.sumBy)(i => {
    var _i$count;
    return (_i$count = i.count) !== null && _i$count !== void 0 ? _i$count : 0;
  }, props.items)) : undefined
}];
exports.buildColumns = buildColumns;
const getItems = (entityData, isAssetCriticalityEnabled) => {
  var _entityData$risk$cate, _entityData$risk$cate2, _entityData$risk$cate3;
  return [{
    category: _i18n.i18n.translate('xpack.securitySolution.flyout.entityDetails.alertsGroupLabel', {
      defaultMessage: 'Alerts'
    }),
    score: (_entityData$risk$cate = entityData === null || entityData === void 0 ? void 0 : entityData.risk.category_1_score) !== null && _entityData$risk$cate !== void 0 ? _entityData$risk$cate : 0,
    count: (_entityData$risk$cate2 = entityData === null || entityData === void 0 ? void 0 : entityData.risk.category_1_count) !== null && _entityData$risk$cate2 !== void 0 ? _entityData$risk$cate2 : 0
  }, ...(isAssetCriticalityEnabled ? [{
    category: _i18n.i18n.translate('xpack.securitySolution.flyout.entityDetails.assetCriticalityGroupLabel', {
      defaultMessage: 'Asset Criticality'
    }),
    score: (_entityData$risk$cate3 = entityData === null || entityData === void 0 ? void 0 : entityData.risk.category_2_score) !== null && _entityData$risk$cate3 !== void 0 ? _entityData$risk$cate3 : 0,
    count: undefined
  }] : [])];
};
exports.getItems = getItems;
function isUserRiskData(riskData) {
  return !!riskData && riskData.user !== undefined;
}
const getEntityData = riskData => {
  if (!riskData) {
    return;
  }
  if (isUserRiskData(riskData)) {
    return riskData.user;
  }
  return riskData.host;
};
exports.getEntityData = getEntityData;
const LENS_VISUALIZATION_HEIGHT = exports.LENS_VISUALIZATION_HEIGHT = 126; //  Static height in pixels specified by design
const LENS_VISUALIZATION_MIN_WIDTH = exports.LENS_VISUALIZATION_MIN_WIDTH = 160; // Lens visualization min-width in pixels
const SUMMARY_TABLE_MIN_WIDTH = exports.SUMMARY_TABLE_MIN_WIDTH = 180; // Summary table min-width in pixels
const LAST_30_DAYS = exports.LAST_30_DAYS = {
  from: 'now-30d',
  to: 'now'
};