"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskSummary = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var i18n = _interopRequireWildcard(require("../../common/components/event_details/cti_details/translations"));
var _threat_summary_view = require("../../common/components/event_details/cti_details/threat_summary_view");
var _common = require("./severity/common");
var _search_strategy = require("../../../common/search_strategy");
var _empty_value = require("../../common/components/empty_value");
var _risk_score_doc_link = require("./risk_score_onboarding/risk_score_doc_link");
var _risk_score_header_title = require("./risk_score_onboarding/risk_score_header_title");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RiskSummaryComponent = ({
  risk,
  riskEntity,
  originalRisk
}) => {
  var _risk$result, _risk$result$, _risk$result$$host, _risk$result$$host$ri, _risk$result2, _risk$result2$, _risk$result2$$user, _risk$result2$$user$r;
  const currentRiskScore = riskEntity === _search_strategy.RiskScoreEntity.host ? risk === null || risk === void 0 ? void 0 : (_risk$result = risk.result) === null || _risk$result === void 0 ? void 0 : (_risk$result$ = _risk$result[0]) === null || _risk$result$ === void 0 ? void 0 : (_risk$result$$host = _risk$result$.host) === null || _risk$result$$host === void 0 ? void 0 : (_risk$result$$host$ri = _risk$result$$host.risk) === null || _risk$result$$host$ri === void 0 ? void 0 : _risk$result$$host$ri.calculated_level : risk === null || risk === void 0 ? void 0 : (_risk$result2 = risk.result) === null || _risk$result2 === void 0 ? void 0 : (_risk$result2$ = _risk$result2[0]) === null || _risk$result2$ === void 0 ? void 0 : (_risk$result2$$user = _risk$result2$.user) === null || _risk$result2$$user === void 0 ? void 0 : (_risk$result2$$user$r = _risk$result2$$user.risk) === null || _risk$result2$$user$r === void 0 ? void 0 : _risk$result2$$user$r.calculated_level;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "s",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_threat_summary_view.ThreatSummaryPanelHeader, {
    title: /*#__PURE__*/_react.default.createElement(_risk_score_header_title.RiskScoreHeaderTitle, {
      title: i18n.RISK_DATA_TITLE(riskEntity),
      riskScoreEntity: riskEntity
    }),
    toolTipTitle: /*#__PURE__*/_react.default.createElement(_risk_score_header_title.RiskScoreHeaderTitle, {
      title: i18n.RISK_DATA_TITLE(riskEntity),
      riskScoreEntity: riskEntity
    }),
    toolTipContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.alertDetails.overview.riskDataTooltipContent",
      defaultMessage: "Risk level is displayed only when available for a {riskEntity}. Ensure {riskScoreDocumentationLink} is enabled within your environment.",
      values: {
        riskEntity,
        riskScoreDocumentationLink: /*#__PURE__*/_react.default.createElement(_risk_score_doc_link.RiskScoreDocLink, {
          riskScoreEntity: riskEntity,
          title: i18n.RISK_SCORE_TITLE(riskEntity)
        })
      }
    })
  }), risk.loading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    "data-test-subj": "loading"
  }), !risk.loading && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_threat_summary_view.EnrichedDataRow, {
    field: i18n.CURRENT_RISK_LEVEL(riskEntity),
    value: currentRiskScore ? /*#__PURE__*/_react.default.createElement(_common.RiskScoreLevel, {
      severity: currentRiskScore,
      hideBackgroundColor: true
    }) : (0, _empty_value.getEmptyValue)()
  }), originalRisk && currentRiskScore !== originalRisk && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_threat_summary_view.EnrichedDataRow, {
    field: i18n.ORIGINAL_RISK_LEVEL(riskEntity),
    value: /*#__PURE__*/_react.default.createElement(_common.RiskScoreLevel, {
      severity: originalRisk,
      hideBackgroundColor: true
    })
  })))));
};
const RiskSummary = exports.RiskSummary = /*#__PURE__*/_react.default.memo(RiskSummaryComponent);