"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScorePreviewTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("./severity/common");
var _links = require("../../common/components/links");
var _risk_engine = require("../../../common/entity_analytics/risk_engine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RiskScorePreviewTable = ({
  items,
  type
}) => {
  const columns = [{
    field: 'id_value',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.riskScore.previewTable.nameColumnTitle",
      defaultMessage: "Name"
    }),
    render: itemName => {
      return type === _risk_engine.RiskScoreEntity.host ? /*#__PURE__*/_react.default.createElement(_links.HostDetailsLink, {
        hostName: itemName
      }) : /*#__PURE__*/_react.default.createElement(_links.UserDetailsLink, {
        userName: itemName
      });
    }
  }, {
    field: 'calculated_level',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.riskScore.previewTable.levelColumnTitle",
      defaultMessage: "Level"
    }),
    render: risk => {
      if (risk != null) {
        return /*#__PURE__*/_react.default.createElement(_common.RiskScoreLevel, {
          severity: risk
        });
      }
      return '';
    }
  }, {
    field: 'calculated_score_norm',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.riskScore.previewTable.scoreNormColumnTitle",
      defaultMessage: "Score norm"
    }),
    render: scoreNorm => {
      if (scoreNorm != null) {
        return Math.round(scoreNorm * 100) / 100;
      }
      return '';
    }
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    "data-test-subj": type === _risk_engine.RiskScoreEntity.host ? 'host-risk-preview-table' : 'user-risk-preview-table',
    responsive: false,
    items: items,
    columns: columns,
    loading: false
  });
};
exports.RiskScorePreviewTable = RiskScorePreviewTable;