"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScoresNoDataDetected = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _search_strategy = require("../../../../common/search_strategy");
var _header_section = require("../../../common/components/header_section");
var i18n = _interopRequireWildcard(require("./translations"));
var _risk_score_header_title = require("./risk_score_header_title");
var _risk_score_restart_button = require("./risk_score_restart_button");
var _use_risk_engine_status = require("../../api/hooks/use_risk_engine_status");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RiskScoresNoDataDetectedComponent = ({
  entityType,
  refetch
}) => {
  const isNewRiskScoreModuleInstalled = (0, _use_risk_engine_status.useIsNewRiskScoreModuleInstalled)();
  const translations = (0, _react.useMemo)(() => ({
    title: entityType === _search_strategy.RiskScoreEntity.user ? i18n.USER_WARNING_TITLE : i18n.HOST_WARNING_TITLE,
    body: entityType === _search_strategy.RiskScoreEntity.user ? i18n.USER_WARNING_BODY : i18n.HOST_WARNING_BODY
  }), [entityType]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": `${entityType}-risk-score-no-data-detected`,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    title: /*#__PURE__*/_react.default.createElement(_risk_score_header_title.RiskScoreHeaderTitle, {
      riskScoreEntity: entityType
    }),
    titleSize: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement("h2", null, translations.title),
    body: translations.body,
    actions: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !isNewRiskScoreModuleInstalled && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: i18n.RESTART_TOOLTIP
    }, /*#__PURE__*/_react.default.createElement(_risk_score_restart_button.RiskScoreRestartButton, {
      refetch: refetch,
      riskScoreEntity: entityType
    })))
  }));
};
const RiskScoresNoDataDetected = exports.RiskScoresNoDataDetected = /*#__PURE__*/_react.default.memo(RiskScoresNoDataDetectedComponent);
RiskScoresNoDataDetected.displayName = 'RiskScoresNoDataDetected';