"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScoreHeaderTitle = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _search_strategy = require("../../../../common/search_strategy");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RiskScoreHeaderTitleComponent = ({
  riskScoreEntity,
  title
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, title !== null && title !== void 0 ? title : riskScoreEntity === _search_strategy.RiskScoreEntity.user ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.entityAnalytics.usersRiskDashboard.title",
  defaultMessage: "User Risk Scores"
}) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.entityAnalytics.hostsRiskDashboard.title",
  defaultMessage: "Host Risk Scores"
}));
const RiskScoreHeaderTitle = exports.RiskScoreHeaderTitle = /*#__PURE__*/_react.default.memo(RiskScoreHeaderTitleComponent);
RiskScoreHeaderTitle.displayName = 'RiskScoreHeaderTitle';