"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScoreEnableSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _links = require("@kbn/security-solution-navigation/links");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var i18n = _interopRequireWildcard(require("../translations"));
var _use_risk_engine_status = require("../api/hooks/use_risk_engine_status");
var _use_init_risk_engine_mutation = require("../api/hooks/use_init_risk_engine_mutation");
var _use_enable_risk_engine_mutation = require("../api/hooks/use_enable_risk_engine_mutation");
var _use_disable_risk_engine_mutation = require("../api/hooks/use_disable_risk_engine_mutation");
var _risk_engine = require("../../../common/entity_analytics/risk_engine");
var _use_app_toasts = require("../../common/hooks/use_app_toasts");
var _risk_information = require("./risk_information");
var _helper_hooks = require("../../helper_hooks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MIN_WIDTH_TO_PREVENT_LABEL_FROM_MOVING = '50px';
const toastOptions = {
  toastLifeTimeMs: 5000
};
const RiskScoreErrorPanel = ({
  errors
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  title: i18n.ERROR_PANEL_TITLE,
  color: "danger",
  iconType: "error",
  "data-test-subj": "risk-score-error-panel"
}, /*#__PURE__*/_react.default.createElement("p", null, i18n.ERROR_PANEL_MESSAGE), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
  id: "risk-engine-erros",
  buttonContent: i18n.ERROR_PANEL_ERRORS
}, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, errors.map(error => /*#__PURE__*/_react.default.createElement("div", {
  key: error
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s"
}, error), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s"
})))))));
const RiskScoreUpdateModal = ({
  closeModal,
  isLoading,
  onConfirm,
  isVisible
}) => {
  if (!isVisible) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: closeModal
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, i18n.UPDATING_RISK_ENGINE))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, i18n.UPDATE_RISK_ENGINE_MODAL_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("b", null, i18n.UPDATE_RISK_ENGINE_MODAL_EXISTING_USER_HOST_1), i18n.UPDATE_RISK_ENGINE_MODAL_EXISTING_USER_HOST_2), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("b", null, i18n.UPDATE_RISK_ENGINE_MODAL_EXISTING_DATA_1), i18n.UPDATE_RISK_ENGINE_MODAL_EXISTING_DATA_2)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "primary",
    "data-test-subj": "risk-score-update-cancel",
    onClick: closeModal
  }, i18n.UPDATE_RISK_ENGINE_MODAL_BUTTON_NO), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    "data-test-subj": "risk-score-update-confirm",
    onClick: onConfirm,
    fill: true
  }, i18n.UPDATE_RISK_ENGINE_MODAL_BUTTON_YES))));
};
const RiskEngineHealth = ({
  currentRiskEngineStatus
}) => {
  if (!currentRiskEngineStatus) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: "subdued"
    }, '-');
  }
  if (currentRiskEngineStatus === _risk_engine.RiskEngineStatus.ENABLED) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: "success"
    }, i18n.RISK_SCORE_MODULE_STATUS_ON);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "subdued"
  }, i18n.RISK_SCORE_MODULE_STATUS_OFF);
};
const RiskEngineStatusRow = ({
  currentRiskEngineStatus,
  onSwitchClick,
  isLoading,
  privileges
}) => {
  const userHasRequiredPrivileges = 'hasAllRequiredPrivileges' in privileges && privileges.hasAllRequiredPrivileges;
  const btnIsDisabled = !currentRiskEngineStatus || isLoading || !userHasRequiredPrivileges;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: 'center'
  }, isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    "data-test-subj": "risk-score-status-loading",
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      minWidth: MIN_WIDTH_TO_PREVENT_LABEL_FROM_MOVING
    },
    "data-test-subj": "risk-score-status"
  }, /*#__PURE__*/_react.default.createElement(RiskEngineHealth, {
    currentRiskEngineStatus: currentRiskEngineStatus
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: '',
    "data-test-subj": "risk-score-switch",
    checked: currentRiskEngineStatus === _risk_engine.RiskEngineStatus.ENABLED,
    onChange: onSwitchClick,
    compressed: true,
    disabled: btnIsDisabled,
    "aria-describedby": 'switchRiskModule'
  })));
};
const RiskScoreEnableSection = ({
  privileges
}) => {
  const {
    addSuccess
  } = (0, _use_app_toasts.useAppToasts)();
  const [isModalVisible, setIsModalVisible] = (0, _react.useState)(false);
  const {
    data: riskEngineStatus,
    isFetching: isStatusLoading
  } = (0, _use_risk_engine_status.useRiskEngineStatus)();
  const initRiskEngineMutation = (0, _use_init_risk_engine_mutation.useInitRiskEngineMutation)({
    onSuccess: () => {
      addSuccess(i18n.RISK_SCORE_MODULE_TURNED_ON, toastOptions);
    },
    onSettled: () => {
      setIsModalVisible(false);
    }
  });
  const enableRiskEngineMutation = (0, _use_enable_risk_engine_mutation.useEnableRiskEngineMutation)({
    onSuccess: () => {
      addSuccess(i18n.RISK_SCORE_MODULE_TURNED_ON, toastOptions);
    }
  });
  const disableRiskEngineMutation = (0, _use_disable_risk_engine_mutation.useDisableRiskEngineMutation)({
    onSuccess: () => {
      addSuccess(i18n.RISK_SCORE_MODULE_TURNED_OFF, toastOptions);
    }
  });
  const currentRiskEngineStatus = riskEngineStatus === null || riskEngineStatus === void 0 ? void 0 : riskEngineStatus.risk_engine_status;
  const closeModal = () => setIsModalVisible(false);
  const showModal = () => setIsModalVisible(true);
  const [isFlyoutVisible, handleOnOpen, handleOnClose] = (0, _helper_hooks.useOnOpenCloseHandler)();
  const isLoading = initRiskEngineMutation.isLoading || enableRiskEngineMutation.isLoading || disableRiskEngineMutation.isLoading || privileges.isLoading || isStatusLoading;
  const isUpdateAvailable = riskEngineStatus === null || riskEngineStatus === void 0 ? void 0 : riskEngineStatus.isUpdateAvailable;
  const onSwitchClick = () => {
    if (!currentRiskEngineStatus || isLoading) {
      return;
    }
    if (currentRiskEngineStatus === _risk_engine.RiskEngineStatus.NOT_INSTALLED) {
      initRiskEngineMutation.mutate();
    } else if (currentRiskEngineStatus === _risk_engine.RiskEngineStatus.ENABLED) {
      disableRiskEngineMutation.mutate();
    } else if (currentRiskEngineStatus === _risk_engine.RiskEngineStatus.DISABLED) {
      enableRiskEngineMutation.mutate();
    }
  };
  let initRiskEngineErrors = [];
  if (initRiskEngineMutation.isError) {
    var _errorBody$full_error;
    const errorBody = initRiskEngineMutation.error.body;
    if (errorBody !== null && errorBody !== void 0 && (_errorBody$full_error = errorBody.full_error) !== null && _errorBody$full_error !== void 0 && _errorBody$full_error.errors) {
      var _errorBody$full_error2;
      initRiskEngineErrors = (_errorBody$full_error2 = errorBody.full_error) === null || _errorBody$full_error2 === void 0 ? void 0 : _errorBody$full_error2.errors;
    } else {
      initRiskEngineErrors = [errorBody.message];
    }
  }
  if (currentRiskEngineStatus !== _risk_engine.RiskEngineStatus.ENABLED && riskEngineStatus !== null && riskEngineStatus !== void 0 && riskEngineStatus.is_max_amount_of_risk_engines_reached) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: i18n.getMaxSpaceTitle(_risk_engine.MAX_SPACES_COUNT),
      color: "warning",
      iconType: "error",
      "data-test-subj": "risk-score-warning-panel"
    }, /*#__PURE__*/_react.default.createElement("p", null, i18n.MAX_SPACE_PANEL_MESSAGE));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, i18n.RISK_SCORE_MODULE_STATUS)), initRiskEngineMutation.isError && /*#__PURE__*/_react.default.createElement(RiskScoreErrorPanel, {
    errors: initRiskEngineErrors
  }), disableRiskEngineMutation.isError && /*#__PURE__*/_react.default.createElement(RiskScoreErrorPanel, {
    errors: [disableRiskEngineMutation.error.body.message]
  }), enableRiskEngineMutation.isError && /*#__PURE__*/_react.default.createElement(RiskScoreErrorPanel, {
    errors: [enableRiskEngineMutation.error.body.message]
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, /*#__PURE__*/_react.default.createElement(RiskScoreUpdateModal, {
    isVisible: isModalVisible,
    onConfirm: () => initRiskEngineMutation.mutate(),
    isLoading: initRiskEngineMutation.isLoading,
    closeModal: closeModal
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: 'baseline'
  }, i18n.ENTITY_RISK_SCORING, isUpdateAvailable && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "success"
  }, i18n.UPDATE_AVAILABLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isUpdateAvailable && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: 'center'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, initRiskEngineMutation.isLoading && !isModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    disabled: initRiskEngineMutation.isLoading,
    color: 'primary',
    onClick: showModal,
    "data-test-subj": "risk-score-update-button"
  }, i18n.START_UPDATE)), !isUpdateAvailable && /*#__PURE__*/_react.default.createElement(RiskEngineStatusRow, {
    currentRiskEngineStatus: currentRiskEngineStatus,
    onSwitchClick: onSwitchClick,
    isLoading: isLoading,
    privileges: privileges
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, i18n.USEFUL_LINKS)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_links.LinkAnchor, {
    id: _securitySolutionNavigation.SecurityPageName.entityAnalytics
  }, i18n.EA_DASHBOARD_LINK), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: handleOnOpen,
    "data-test-subj": "open-risk-information-flyout-trigger"
  }, i18n.EA_DOCS_ENTITY_RISK_SCORE), isFlyoutVisible && /*#__PURE__*/_react.default.createElement(_risk_information.RiskInformationFlyout, {
    handleOnClose: handleOnClose
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })))));
};
exports.RiskScoreEnableSection = RiskScoreEnableSection;