"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRiskInputActionsPanels = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/cases-plugin/common");
var _i18n = require("@kbn/i18n");
var _fp = require("lodash/fp");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _use_risk_input_actions = require("./use_risk_input_actions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useRiskInputActionsPanels = (inputs, closePopover) => {
  const {
    cases: casesService
  } = (0, _public.useKibana)().services;
  const {
    addToExistingCase,
    addToNewCaseClick,
    addToNewTimeline
  } = (0, _use_risk_input_actions.useRiskInputActions)(inputs, closePopover);
  const userCasesPermissions = casesService === null || casesService === void 0 ? void 0 : casesService.helpers.canUseCases([_common.SECURITY_SOLUTION_OWNER]);
  const hasCasesPermissions = (userCasesPermissions === null || userCasesPermissions === void 0 ? void 0 : userCasesPermissions.create) && (userCasesPermissions === null || userCasesPermissions === void 0 ? void 0 : userCasesPermissions.read);
  return (0, _react.useMemo)(() => {
    var _get;
    const timelinePanel = {
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.entityDetails.riskInputs.actions.addToNewTimeline",
        defaultMessage: "Add to new timeline"
      }),
      onClick: addToNewTimeline
    };
    const ruleName = (_get = (0, _fp.get)(['alert', _ruleDataUtils.ALERT_RULE_NAME], inputs[0])) !== null && _get !== void 0 ? _get : '';
    const title = _i18n.i18n.translate('xpack.securitySolution.flyout.entityDetails.riskInputs.actions.title', {
      defaultMessage: 'Risk input: {description}',
      values: {
        description: inputs.length === 1 ? ruleName : _i18n.i18n.translate('xpack.securitySolution.flyout.entityDetails.riskInputs.actions.titleDescription', {
          defaultMessage: '{quantity} selected',
          values: {
            quantity: inputs.length
          }
        })
      }
    });
    return [{
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiTextTruncate, {
        width: 230 // It prevents the title from taking too much space
        ,
        text: title
      }),
      id: 0,
      items: hasCasesPermissions ? [timelinePanel, {
        name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.flyout.entityDetails.riskInputs.actions.addToNewCase",
          defaultMessage: "Add to new case"
        }),
        onClick: addToNewCaseClick
      }, {
        name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.flyout.entityDetails.riskInputs.actions.addToExistingCase",
          defaultMessage: "Add to existing case"
        }),
        onClick: addToExistingCase
      }] : [timelinePanel]
    }];
  }, [addToExistingCase, addToNewCaseClick, addToNewTimeline, inputs, hasCasesPermissions]);
};
exports.useRiskInputActionsPanels = useRiskInputActionsPanels;