"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetCriticalityFilePickerStep = void 0;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _uiTheme = require("@kbn/ui-theme");
var _asset_criticality = require("../../../../../common/entity_analytics/asset_criticality");
var _formatted_bytes = require("../../../../common/components/formatted_bytes");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sampleCSVContent = `user,user-001,low_impact\nuser,user-002,medium_impact\nhost,host-001,extreme_impact`;
const listStyle = (0, _css.css)`
  list-style-type: disc;
  margin-bottom: ${_uiTheme.euiThemeVars.euiSizeL};
  margin-left: ${_uiTheme.euiThemeVars.euiSizeL};
  line-height: ${_uiTheme.euiThemeVars.euiLineHeight};
`;
const AssetCriticalityFilePickerStep = exports.AssetCriticalityFilePickerStep = /*#__PURE__*/_react.default.memo(({
  onFileChange,
  errorMessage,
  isLoading
}) => {
  const formatBytes = (0, _formatted_bytes.useFormatBytes)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: 'subdued',
    paddingSize: "l",
    grow: false,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "CSV File Format Requirements",
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.csvFileFormatRequirements"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("ul", {
    className: listStyle
  }, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Supported file formats: {formats}",
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.acceptedFileFormats",
    values: {
      formats: _constants.SUPPORTED_FILE_EXTENSIONS.join(', ')
    }
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "You can upload files up to {maxFileSize}",
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.uploadFileSizeLimit",
    values: {
      maxFileSize: formatBytes(_asset_criticality.CRITICALITY_CSV_MAX_SIZE_BYTES)
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Required CSV Structure",
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.CSVStructureTitle"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("ul", {
    className: listStyle
  }, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Resource type: Indicate whether the resource is a {host} or a {user}.",
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.assetTypeDescription",
    values: {
      host: /*#__PURE__*/_react.default.createElement("b", null, 'host'),
      user: /*#__PURE__*/_react.default.createElement("b", null, 'user')
    }
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Identifier: The unique identifier for each asset's {hostName} or {userName}.",
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.assetIdentifierDescription",
    values: {
      hostName: /*#__PURE__*/_react.default.createElement("b", null, 'Host.name'),
      userName: /*#__PURE__*/_react.default.createElement("b", null, 'User.name')
    }
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Criticality label: Use any one of {labels}",
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.assetCriticalityLabels",
    values: {
      labels: /*#__PURE__*/_react.default.createElement("b", null, _asset_criticality.ValidCriticalityLevels.join(', '))
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Example",
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.exampleTitle"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "csv",
    css: (0, _css.css)`
              background-color: ${euiTheme.colors.emptyShade};
            `,
    paddingSize: "s",
    lineNumbers: true,
    isCopyable: true
  }, sampleCSVContent)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
    "data-test-subj": "asset-criticality-file-picker",
    accept: _constants.SUPPORTED_FILE_TYPES.join(','),
    fullWidth: true,
    onChange: onFileChange,
    isInvalid: !!errorMessage,
    isLoading: isLoading
  }), /*#__PURE__*/_react.default.createElement("br", null), errorMessage && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: 'danger',
    size: "xs"
  }, errorMessage));
});
AssetCriticalityFilePickerStep.displayName = 'AssetCriticalityFilePickerStep';