"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.routes = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _constants = require("../../common/constants");
var _plugin_template_wrapper = require("../common/components/plugin_template_wrapper");
var _alerts = require("./pages/alerts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertsRoutes = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, null, /*#__PURE__*/_react.default.createElement(_alerts.Alerts, null));
const DetectionsRedirects = ({
  location
}) => location.pathname === _constants.DETECTIONS_PATH ? /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
  to: {
    ...location,
    pathname: _constants.ALERTS_PATH
  }
}) : /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
  to: {
    ...location,
    pathname: location.pathname.replace(_constants.DETECTIONS_PATH, '')
  }
});
const routes = exports.routes = [{
  path: _constants.DETECTIONS_PATH,
  render: DetectionsRedirects
}, {
  path: _constants.ALERTS_PATH,
  component: AlertsRoutes
}];