"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditRuleSettingButtonLink = EditRuleSettingButtonLink;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _kibana = require("../../../../../../common/lib/kibana");
var _links = require("../../../../../../common/components/links");
var _constants = require("../../../../../../../common/constants");
var _types = require("../../../../../../app/types");
var _redirect_to_detection_engine = require("../../../../../../common/components/link_to/redirect_to_detection_engine");
var ruleI18n = _interopRequireWildcard(require("../../translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EditRuleSettingButtonLink({
  ruleId,
  disabled = false,
  disabledReason
}) {
  const {
    application: {
      navigateToApp
    }
  } = (0, _kibana.useKibana)().services;
  const goToEditRule = (0, _react.useCallback)(ev => {
    ev.preventDefault();
    navigateToApp(_constants.APP_UI_ID, {
      deepLinkId: _types.SecurityPageName.rules,
      path: (0, _redirect_to_detection_engine.getEditRuleUrl)(ruleId)
    });
  }, [navigateToApp, ruleId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: disabledReason
  }, /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkButton, {
    "data-test-subj": "editRuleSettingsLink",
    onClick: goToEditRule,
    iconType: "controlsHorizontal",
    isDisabled: disabled,
    deepLinkId: _types.SecurityPageName.rules,
    path: (0, _redirect_to_detection_engine.getEditRuleUrl)(ruleId)
  }, ruleI18n.EDIT_RULE_SETTINGS));
}