"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartPanels = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _alerts_local_storage = require("./alerts_local_storage");
var _chart_context_menu = require("./chart_context_menu");
var _chart_select = require("./chart_select");
var _chart_collapse = require("./chart_collapse");
var i18n = _interopRequireWildcard(require("./chart_select/translations"));
var _alerts_treemap_panel = require("../../../../common/components/alerts_treemap_panel");
var _use_combo_box_reset = require("../../../../common/components/use_combo_box_reset");
var _alerts_histogram_panel = require("../../../components/alerts_kpis/alerts_histogram_panel");
var _alerts_summary_charts_panel = require("../../../components/alerts_kpis/alerts_summary_charts_panel");
var _config = require("../../../components/alerts_kpis/common/config");
var _alerts_count_panel = require("../../../components/alerts_kpis/alerts_count_panel");
var _translations2 = require("../../../components/alerts_kpis/common/translations");
var _query_toggle = require("../../../../common/containers/query_toggle");
var _helpers = require("../../../components/alerts_kpis/alerts_histogram_panel/helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TREND_CHART_HEIGHT = 240; // px
const CHART_PANEL_HEIGHT = 375; // px

const DETECTIONS_ALERTS_CHARTS_PANEL_ID = 'detection-alerts-charts-panel';
const FullHeightFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  height: 100%;
`;
const ChartSelectContainer = _styledComponents.default.div`
  margin-left: ${({
  theme
}) => theme.eui.euiSizeS};
`;
const ChartPanelsComponent = ({
  addFilter,
  alertsDefaultFilters,
  isLoadingIndexPattern,
  query,
  runtimeMappings,
  signalIndexName,
  updateDateRangeCallback
}) => {
  const {
    toggleStatus: isExpanded,
    setToggleStatus: setIsExpanded
  } = (0, _query_toggle.useQueryToggle)(DETECTIONS_ALERTS_CHARTS_PANEL_ID);
  const isAlertsPageChartsEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('alertsPageChartsEnabled');
  const {
    alertViewSelection,
    countTableStackBy0,
    countTableStackBy1,
    groupBySelection,
    isTreemapPanelExpanded,
    riskChartStackBy0,
    riskChartStackBy1,
    setAlertViewSelection,
    setCountTableStackBy0,
    setCountTableStackBy1,
    setGroupBySelection,
    setIsTreemapPanelExpanded,
    setRiskChartStackBy0,
    setRiskChartStackBy1,
    setTrendChartStackBy,
    trendChartStackBy
  } = (0, _alerts_local_storage.useAlertsLocalStorage)();
  const updateCommonStackBy0 = (0, _react.useCallback)(value => {
    setTrendChartStackBy(value);
    setCountTableStackBy0(value);
    setRiskChartStackBy0(value);
  }, [setCountTableStackBy0, setRiskChartStackBy0, setTrendChartStackBy]);
  const updateCommonStackBy1 = (0, _react.useCallback)(value => {
    setCountTableStackBy1(value);
    setRiskChartStackBy1(value);
  }, [setCountTableStackBy1, setRiskChartStackBy1]);
  const {
    comboboxRef: stackByField0ComboboxRef,
    onReset: onResetStackByField0,
    setComboboxInputRef: setStackByField0ComboboxInputRef
  } = (0, _use_combo_box_reset.useEuiComboBoxReset)();
  const {
    comboboxRef: stackByField1ComboboxRef,
    onReset: onResetStackByField1,
    setComboboxInputRef: setStackByField1ComboboxInputRef
  } = (0, _use_combo_box_reset.useEuiComboBoxReset)();
  const onReset = (0, _react.useCallback)(() => {
    onResetStackByField0();
    onResetStackByField1();
  }, [onResetStackByField0, onResetStackByField1]);
  const handleResetGroupByFieldAction = (0, _react.useCallback)(() => {
    onReset();
    updateCommonStackBy0(_config.DEFAULT_STACK_BY_FIELD);
    if (updateCommonStackBy1 != null) {
      updateCommonStackBy1(_config.DEFAULT_STACK_BY_FIELD1);
    }
  }, [onReset, updateCommonStackBy0, updateCommonStackBy1]);
  const resetGroupByFieldAction = (0, _react.useMemo)(() => [(0, _helpers.createResetGroupByFieldAction)({
    callback: handleResetGroupByFieldAction,
    order: 5
  })], [handleResetGroupByFieldAction]);
  const chartOptionsContextMenu = (0, _react.useCallback)(queryId => /*#__PURE__*/_react.default.createElement(_chart_context_menu.ChartContextMenu, {
    defaultStackByField: _config.DEFAULT_STACK_BY_FIELD,
    defaultStackByField1: _config.DEFAULT_STACK_BY_FIELD1,
    onReset: onReset,
    queryId: queryId,
    setStackBy: updateCommonStackBy0,
    setStackByField1: updateCommonStackBy1
  }), [onReset, updateCommonStackBy0, updateCommonStackBy1]);
  const title = (0, _react.useMemo)(() => {
    if (isAlertsPageChartsEnabled) {
      return isExpanded ? /*#__PURE__*/_react.default.createElement(ChartSelectContainer, null, /*#__PURE__*/_react.default.createElement(_chart_select.ChartSelect, {
        alertViewSelection: alertViewSelection,
        setAlertViewSelection: setAlertViewSelection
      })) : /*#__PURE__*/_react.default.createElement(_chart_collapse.ChartCollapse, {
        groupBySelection: groupBySelection,
        filters: alertsDefaultFilters,
        query: query,
        signalIndexName: signalIndexName,
        runtimeMappings: runtimeMappings
      });
    } else {
      return /*#__PURE__*/_react.default.createElement(ChartSelectContainer, null, /*#__PURE__*/_react.default.createElement(_chart_select.ChartSelect, {
        alertViewSelection: alertViewSelection,
        setAlertViewSelection: setAlertViewSelection
      }));
    }
  }, [alertViewSelection, setAlertViewSelection, isAlertsPageChartsEnabled, isExpanded, groupBySelection, alertsDefaultFilters, query, signalIndexName, runtimeMappings]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "chartPanels"
  }, alertViewSelection === 'trend' && /*#__PURE__*/_react.default.createElement(FullHeightFlexItem, {
    grow: 2
  }, isLoadingIndexPattern ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 10,
    "data-test-subj": "trendLoadingSpinner"
  }) : /*#__PURE__*/_react.default.createElement(_alerts_histogram_panel.AlertsHistogramPanel, {
    alignHeader: "flexStart",
    chartHeight: TREND_CHART_HEIGHT,
    comboboxRef: stackByField0ComboboxRef,
    defaultStackByOption: trendChartStackBy,
    extraActions: resetGroupByFieldAction,
    filters: alertsDefaultFilters,
    inspectTitle: i18n.TREND,
    onFieldSelected: updateCommonStackBy0,
    panelHeight: CHART_PANEL_HEIGHT,
    setComboboxInputRef: setStackByField0ComboboxInputRef,
    showGroupByPlaceholder: false,
    showTotalAlertsCount: false,
    signalIndexName: signalIndexName,
    stackByLabel: _translations2.GROUP_BY_LABEL,
    title: title,
    titleSize: 's',
    updateDateRange: updateDateRangeCallback,
    isExpanded: isExpanded,
    setIsExpanded: setIsExpanded
  })), alertViewSelection === 'table' && /*#__PURE__*/_react.default.createElement(FullHeightFlexItem, {
    grow: 1
  }, isLoadingIndexPattern ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 10,
    "data-test-subj": "tableLoadingSpinner"
  }) : /*#__PURE__*/_react.default.createElement(_alerts_count_panel.AlertsCountPanel, {
    alignHeader: "flexStart",
    chartOptionsContextMenu: chartOptionsContextMenu,
    extraActions: resetGroupByFieldAction,
    filters: alertsDefaultFilters,
    inspectTitle: isAlertsPageChartsEnabled ? i18n.COUNTS : i18n.TABLE,
    panelHeight: CHART_PANEL_HEIGHT,
    setStackByField0: updateCommonStackBy0,
    setStackByField0ComboboxInputRef: setStackByField0ComboboxInputRef,
    setStackByField1: updateCommonStackBy1,
    setStackByField1ComboboxInputRef: setStackByField1ComboboxInputRef,
    stackByField0: countTableStackBy0,
    stackByField0ComboboxRef: stackByField0ComboboxRef,
    stackByField1: countTableStackBy1,
    stackByField1ComboboxRef: stackByField1ComboboxRef,
    title: title,
    isExpanded: isExpanded,
    setIsExpanded: setIsExpanded
  })), alertViewSelection === 'treemap' && /*#__PURE__*/_react.default.createElement(FullHeightFlexItem, {
    grow: 1
  }, isLoadingIndexPattern ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 10,
    "data-test-subj": "treemapLoadingSpinner"
  }) : /*#__PURE__*/_react.default.createElement(_alerts_treemap_panel.AlertsTreemapPanel, {
    addFilter: addFilter,
    alignHeader: "flexStart",
    chartOptionsContextMenu: chartOptionsContextMenu,
    height: CHART_PANEL_HEIGHT,
    inspectTitle: i18n.TREEMAP,
    isPanelExpanded: isAlertsPageChartsEnabled ? isExpanded : isTreemapPanelExpanded,
    filters: alertsDefaultFilters,
    query: query,
    riskSubAggregationField: "kibana.alert.risk_score",
    setIsPanelExpanded: isAlertsPageChartsEnabled ? setIsExpanded : setIsTreemapPanelExpanded,
    setStackByField0: updateCommonStackBy0,
    setStackByField0ComboboxInputRef: setStackByField0ComboboxInputRef,
    setStackByField1: updateCommonStackBy1,
    setStackByField1ComboboxInputRef: setStackByField1ComboboxInputRef,
    signalIndexName: signalIndexName,
    stackByField0: riskChartStackBy0,
    stackByField0ComboboxRef: stackByField0ComboboxRef,
    stackByField1: riskChartStackBy1,
    stackByField1ComboboxRef: stackByField1ComboboxRef,
    title: title
  })), isAlertsPageChartsEnabled && alertViewSelection === 'charts' && /*#__PURE__*/_react.default.createElement(FullHeightFlexItem, {
    grow: 1
  }, isLoadingIndexPattern ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 10,
    "data-test-subj": "chartsLoadingSpinner"
  }) : /*#__PURE__*/_react.default.createElement(_alerts_summary_charts_panel.AlertsSummaryChartsPanel, {
    alignHeader: "flexStart",
    addFilter: addFilter,
    filters: alertsDefaultFilters,
    query: query,
    panelHeight: CHART_PANEL_HEIGHT,
    signalIndexName: signalIndexName,
    title: title,
    runtimeMappings: runtimeMappings,
    isExpanded: isExpanded,
    setIsExpanded: setIsExpanded,
    groupBySelection: groupBySelection,
    setGroupBySelection: setGroupBySelection
  })));
};
const ChartPanels = exports.ChartPanels = /*#__PURE__*/_react.default.memo(ChartPanelsComponent);