"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartSelect = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _helpers = require("./helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_experimental_features = require("../../../../../common/hooks/use_experimental_features");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChartTypeIcon = (0, _styledComponents.default)(_eui.EuiIcon)`
  margin-right: ${({
  theme
}) => theme.eui.euiSizeS};
`;
const AlertViewOptions = ['charts', 'trend', 'table', 'treemap'];
const ChartSelectComponent = ({
  alertViewSelection,
  setAlertViewSelection
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), []);
  const onButtonClick = (0, _react.useCallback)(() => setIsPopoverOpen(currentVal => !currentVal), []);
  const button = (0, _react.useMemo)(() => {
    const buttonProperties = (0, _helpers.getButtonProperties)(alertViewSelection);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "aria-label": i18n.SELECT_A_CHART_ARIA_LABEL,
      className: "kbnToolbarButton",
      color: "text",
      "data-test-subj": "chartSelect",
      iconSide: "right",
      iconType: "arrowDown",
      onClick: onButtonClick
    }, /*#__PURE__*/_react.default.createElement(ChartTypeIcon, {
      type: buttonProperties.icon
    }), /*#__PURE__*/_react.default.createElement("span", null, buttonProperties.name));
  }, [alertViewSelection, onButtonClick]);
  const isAlertsPageChartsEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('alertsPageChartsEnabled');
  const options = (0, _react.useMemo)(() => {
    return AlertViewOptions.map(option => (0, _helpers.getOptionProperties)(option));
  }, []);
  const panels = (0, _react.useMemo)(() => (0, _helpers.getContextMenuPanels)({
    alertViewSelection,
    closePopover,
    setAlertViewSelection,
    isAlertsPageChartsEnabled
  }), [alertViewSelection, closePopover, setAlertViewSelection, isAlertsPageChartsEnabled]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isAlertsPageChartsEnabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    name: "chart-select",
    legend: i18n.LEGEND_TITLE,
    options: options,
    idSelected: alertViewSelection,
    onChange: id => setAlertViewSelection(id),
    buttonSize: "compressed",
    color: "primary",
    "data-test-subj": "chart-select-tabs"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downLeft",
    button: button,
    closePopover: closePopover,
    isOpen: isPopoverOpen,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels
  })));
};
ChartSelectComponent.displayName = 'ChartSelectComponent';
const ChartSelect = exports.ChartSelect = /*#__PURE__*/_react.default.memo(ChartSelectComponent);