"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPersistentControlsHook = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _use_get_group_selector = require("@kbn/securitysolution-grouping/src/hooks/use_get_group_selector");
var _const = require("@kbn/securitysolution-grouping/src/telemetry/const");
var _selectors = require("../../../common/store/grouping/selectors");
var _sourcerer = require("../../../common/containers/sourcerer");
var _model = require("../../../common/store/sourcerer/model");
var _actions = require("../../../common/store/grouping/actions");
var _kibana = require("../../../common/lib/kibana");
var _telemetry = require("../../../common/lib/telemetry");
var _use_data_table_filters = require("../../../common/hooks/use_data_table_filters");
var _use_selector = require("../../../common/hooks/use_selector");
var _right_top_menu = require("../../../common/components/events_viewer/right_top_menu");
var _additional_filters_action = require("../../components/alerts_table/additional_filters_action");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  changeViewMode
} = _securitysolutionDataTable.dataTableActions;
const getPersistentControlsHook = tableId => {
  const usePersistentControls = () => {
    var _useDeepEqualSelector;
    const dispatch = (0, _reactRedux.useDispatch)();
    const {
      services: {
        telemetry
      }
    } = (0, _kibana.useKibana)();
    const {
      indexPattern
    } = (0, _sourcerer.useSourcererDataView)(_model.SourcererScopeName.detections);
    const groupId = (0, _react.useMemo)(() => (0, _selectors.groupIdSelector)(), []);
    const {
      options
    } = (_useDeepEqualSelector = (0, _use_selector.useDeepEqualSelector)(state => groupId(state, tableId))) !== null && _useDeepEqualSelector !== void 0 ? _useDeepEqualSelector : {
      options: []
    };
    const trackGroupChange = (0, _react.useCallback)(groupSelection => {
      _telemetry.track === null || _telemetry.track === void 0 ? void 0 : (0, _telemetry.track)(_telemetry.METRIC_TYPE.CLICK, _const.getTelemetryEvent.groupChanged({
        groupingId: tableId,
        selected: groupSelection
      }));
      telemetry.reportAlertsGroupingChanged({
        groupByField: groupSelection,
        tableId
      });
    }, [telemetry]);
    const onGroupChange = (0, _react.useCallback)(selectedGroups => {
      selectedGroups.forEach(g => trackGroupChange(g));
      dispatch((0, _actions.updateGroups)({
        activeGroups: selectedGroups,
        tableId
      }));
    }, [dispatch, trackGroupChange]);
    const groupSelector = (0, _use_get_group_selector.useGetGroupSelectorStateless)({
      groupingId: tableId,
      onGroupChange,
      fields: indexPattern.fields,
      defaultGroupingOptions: options,
      maxGroupingLevels: 3
    });
    const getTable = (0, _react.useMemo)(() => _securitysolutionDataTable.dataTableSelectors.getTableByIdSelector(), []);
    const tableView = (0, _use_selector.useShallowEqualSelector)(state => {
      var _viewMode, _getTable;
      return (_viewMode = ((_getTable = getTable(state, tableId)) !== null && _getTable !== void 0 ? _getTable : _securitysolutionDataTable.tableDefaults).viewMode) !== null && _viewMode !== void 0 ? _viewMode : _securitysolutionDataTable.tableDefaults.viewMode;
    });
    const handleChangeTableView = (0, _react.useCallback)(selectedView => {
      dispatch(changeViewMode({
        id: tableId,
        viewMode: selectedView
      }));
    }, [dispatch]);
    const {
      showBuildingBlockAlerts,
      setShowBuildingBlockAlerts,
      showOnlyThreatIndicatorAlerts,
      setShowOnlyThreatIndicatorAlerts
    } = (0, _use_data_table_filters.useDataTableFilters)(tableId);
    const additionalFiltersComponent = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_additional_filters_action.AdditionalFiltersAction, {
      areEventsLoading: false,
      onShowBuildingBlockAlertsChanged: setShowBuildingBlockAlerts,
      showBuildingBlockAlerts: showBuildingBlockAlerts,
      onShowOnlyThreatIndicatorAlertsChanged: setShowOnlyThreatIndicatorAlerts,
      showOnlyThreatIndicatorAlerts: showOnlyThreatIndicatorAlerts
    }), [showBuildingBlockAlerts, setShowBuildingBlockAlerts, showOnlyThreatIndicatorAlerts, setShowOnlyThreatIndicatorAlerts]);
    const rightTopMenu = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_right_top_menu.RightTopMenu, {
      position: "relative",
      tableView: tableView,
      loading: false,
      tableId: tableId,
      title: 'Some Title',
      onViewChange: handleChangeTableView,
      hasRightOffset: false,
      additionalFilters: additionalFiltersComponent,
      showInspect: false,
      additionalMenuOptions: groupSelector != null ? [groupSelector] : []
    }), [tableView, handleChangeTableView, additionalFiltersComponent, groupSelector]);
    return (0, _react.useMemo)(() => ({
      right: rightTopMenu
    }), [rightTopMenu]);
  };
  return usePersistentControls;
};
exports.getPersistentControlsHook = getPersistentControlsHook;