"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.userRiskLevelColumn = exports.hostRiskLevelColumn = exports.getRulePreviewColumns = exports.getColumns = exports.eventRenderedViewColumns = exports.assigneesColumn = void 0;
var _field_names = require("../../../../common/field_maps/field_names");
var _default_headers = require("../../../timelines/components/timeline/body/column_headers/default_headers");
var _constants = require("../../../timelines/components/timeline/body/constants");
var i18n = _interopRequireWildcard(require("../../components/alerts_table/translations"));
var _translations2 = require("./translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const assigneesColumn = exports.assigneesColumn = {
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  displayAsText: i18n.ALERTS_HEADERS_ASSIGNEES,
  id: 'kibana.alert.workflow_assignee_ids',
  initialWidth: _constants.DEFAULT_DATE_COLUMN_MIN_WIDTH
};
const hostRiskLevelColumn = exports.hostRiskLevelColumn = {
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  id: _field_names.ALERT_HOST_RISK_SCORE_CALCULATED_LEVEL,
  displayAsText: i18n.ALERTS_HEADERS_HOST_RISK_LEVEL
};
const userRiskLevelColumn = exports.userRiskLevelColumn = {
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  id: _field_names.ALERT_USER_RISK_SCORE_CALCULATED_LEVEL,
  displayAsText: i18n.ALERTS_HEADERS_USER_RISK_LEVEL
};
const getBaseColumns = license => {
  var _license$isPlatinumPl, _license$isPlatinumPl2;
  const isPlatinumPlus = (_license$isPlatinumPl = license === null || license === void 0 ? void 0 : (_license$isPlatinumPl2 = license.isPlatinumPlus) === null || _license$isPlatinumPl2 === void 0 ? void 0 : _license$isPlatinumPl2.call(license)) !== null && _license$isPlatinumPl !== void 0 ? _license$isPlatinumPl : false;
  return [{
    columnHeaderType: _default_headers.defaultColumnHeaderType,
    displayAsText: i18n.ALERTS_HEADERS_SEVERITY,
    id: 'kibana.alert.severity',
    initialWidth: 105
  }, {
    columnHeaderType: _default_headers.defaultColumnHeaderType,
    displayAsText: i18n.ALERTS_HEADERS_RISK_SCORE,
    id: 'kibana.alert.risk_score',
    initialWidth: 100
  }, {
    columnHeaderType: _default_headers.defaultColumnHeaderType,
    displayAsText: i18n.ALERTS_HEADERS_REASON,
    id: 'kibana.alert.reason',
    initialWidth: 450
  }, {
    columnHeaderType: _default_headers.defaultColumnHeaderType,
    id: 'host.name'
  }, {
    columnHeaderType: _default_headers.defaultColumnHeaderType,
    id: 'user.name'
  }, isPlatinumPlus ? hostRiskLevelColumn : null, isPlatinumPlus ? userRiskLevelColumn : null, isPlatinumPlus ? {
    columnHeaderType: _default_headers.defaultColumnHeaderType,
    id: _field_names.ALERT_HOST_CRITICALITY,
    displayAsText: i18n.ALERTS_HEADERS_HOST_CRITICALITY
  } : null, isPlatinumPlus ? {
    columnHeaderType: _default_headers.defaultColumnHeaderType,
    id: _field_names.ALERT_USER_CRITICALITY,
    displayAsText: i18n.ALERTS_HEADERS_USER_CRITICALITY
  } : null, {
    columnHeaderType: _default_headers.defaultColumnHeaderType,
    id: 'process.name'
  }, {
    columnHeaderType: _default_headers.defaultColumnHeaderType,
    id: 'file.name'
  }, {
    columnHeaderType: _default_headers.defaultColumnHeaderType,
    id: 'source.ip'
  }, {
    columnHeaderType: _default_headers.defaultColumnHeaderType,
    id: 'destination.ip'
  }].filter(column => column != null);
};

/**
 * columns implements a subset of `EuiDataGrid`'s `EuiDataGridColumn` interface,
 * plus additional TGrid column properties
 */
const getColumns = license => [{
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  id: '@timestamp',
  initialWidth: _constants.DEFAULT_DATE_COLUMN_MIN_WIDTH + 10
}, {
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  displayAsText: i18n.ALERTS_HEADERS_RULE,
  id: 'kibana.alert.rule.name',
  initialWidth: _constants.DEFAULT_COLUMN_MIN_WIDTH,
  linkField: 'kibana.alert.rule.uuid'
}, assigneesColumn, ...getBaseColumns(license)];
exports.getColumns = getColumns;
const getRulePreviewColumns = license => [{
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  id: 'kibana.alert.original_time',
  initialWidth: _constants.DEFAULT_DATE_COLUMN_MIN_WIDTH + 10
}, ...getBaseColumns(license)];
exports.getRulePreviewColumns = getRulePreviewColumns;
const eventRenderedViewColumns = exports.eventRenderedViewColumns = [{
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  id: '@timestamp',
  displayAsText: i18n.EVENT_RENDERED_VIEW_COLUMNS.timestamp,
  initialWidth: _translations2.DEFAULT_TABLE_DATE_COLUMN_MIN_WIDTH + 50,
  actions: false,
  isExpandable: false,
  isResizable: false
}, {
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  displayAsText: i18n.EVENT_RENDERED_VIEW_COLUMNS.rule,
  id: 'kibana.alert.rule.name',
  initialWidth: _translations2.DEFAULT_TABLE_COLUMN_MIN_WIDTH + 50,
  linkField: 'kibana.alert.rule.uuid',
  actions: false,
  isExpandable: false,
  isResizable: false
}, {
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  id: 'eventSummary',
  displayAsText: i18n.EVENT_RENDERED_VIEW_COLUMNS.eventSummary,
  actions: false,
  isExpandable: false,
  isResizable: false
}];