"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RenderCellValue = void 0;
var _fp = require("lodash/fp");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _truncatable_text = require("../../../../common/components/truncatable_text");
var _severity = require("../../../components/severity");
var _data_driven_columns = require("../../../../timelines/components/timeline/body/data_driven_columns");
var _default_cell_renderer = require("../../../../timelines/components/timeline/cell_rendering/default_cell_renderer");
var _status = require("../../../components/status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const reason = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.';

/**
 * This implementation of `EuiDataGrid`'s `renderCellValue`
 * accepts `EuiDataGridCellValueElementProps`, plus `data`
 * from the TGrid
 */
const RenderCellValue = ({
  columnId,
  data,
  eventId,
  header,
  isDetails,
  isDraggable,
  isExpandable,
  isExpanded,
  linkValues,
  rowIndex,
  colIndex,
  setCellProps,
  scopeId,
  key
}) => {
  var _useGetMappedNonEcsVa, _useGetMappedNonEcsVa2;
  const value = (_useGetMappedNonEcsVa = (_useGetMappedNonEcsVa2 = (0, _data_driven_columns.useGetMappedNonEcsValue)({
    data,
    fieldName: columnId
  })) === null || _useGetMappedNonEcsVa2 === void 0 ? void 0 : _useGetMappedNonEcsVa2.reduce(x => x[0])) !== null && _useGetMappedNonEcsVa !== void 0 ? _useGetMappedNonEcsVa : '';
  switch (columnId) {
    case _ruleDataUtils.ALERT_STATUS:
      return /*#__PURE__*/_react.default.createElement(_status.Status, {
        "data-test-subj": "alert-status",
        status: (0, _fp.random)(0, 1) ? 'recovered' : 'active'
      });
    case _ruleDataUtils.ALERT_DURATION:
    case 'signal.duration.us':
      return /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "alert-duration"
      }, (0, _moment.default)().fromNow(true));
    case _ruleDataUtils.ALERT_SEVERITY:
    case 'signal.rule.severity':
      return /*#__PURE__*/_react.default.createElement(_severity.Severity, {
        "data-test-subj": "rule-severity",
        severity: value
      });
    case _ruleDataUtils.ALERT_REASON:
    case 'signal.reason':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "reason"
      }, /*#__PURE__*/_react.default.createElement(_truncatable_text.TruncatableText, null, reason));
    default:
      // NOTE: we're using `DefaultCellRenderer` in this example configuration as a fallback, but
      // using `DefaultCellRenderer` here is entirely optional
      return /*#__PURE__*/_react.default.createElement(_default_cell_renderer.DefaultCellRenderer, {
        columnId: columnId,
        data: data,
        eventId: eventId,
        header: header,
        isDetails: isDetails,
        isDraggable: isDraggable,
        isExpandable: isExpandable,
        isExpanded: isExpanded,
        linkValues: linkValues,
        rowIndex: rowIndex,
        colIndex: colIndex,
        setCellProps: setCellProps,
        scopeId: scopeId,
        key: key
      });
  }
};
exports.RenderCellValue = RenderCellValue;