"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildColumns = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _show_value_list_modal = require("../../../value_list/components/show_value_list_modal");
var _formatted_date = require("../../../common/components/formatted_date");
var i18n = _interopRequireWildcard(require("./translations"));
var _form = require("./form");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlignedSpinner = (0, _styledComponents.default)(_eui.EuiLoadingSpinner)`
  margin: ${({
  theme
}) => theme.eui.euiSizeXS};
  vertical-align: middle;
`;
const buildColumns = (onExport, onDelete) => [{
  field: 'name',
  name: i18n.COLUMN_FILE_NAME,
  truncateText: false,
  render: (name, item) => /*#__PURE__*/_react.default.createElement(_show_value_list_modal.ShowValueListModal, {
    shouldShowContentIfModalNotAvailable: true,
    listId: item.id
  }, name)
}, {
  field: 'type',
  name: i18n.COLUMN_TYPE,
  width: '15%',
  truncateText: true,
  render: type => {
    const option = _form.listFormOptions.find(({
      value
    }) => value === type);
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, option ? option.text : type);
  }
}, {
  field: 'created_at',
  name: i18n.COLUMN_UPLOAD_DATE,
  render: value => /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
    value: value,
    fieldName: "created_at"
  }),
  width: '30%'
}, {
  field: 'created_by',
  name: i18n.COLUMN_CREATED_BY,
  truncateText: true,
  width: '20%'
}, {
  name: i18n.COLUMN_ACTIONS,
  actions: [{
    render: item => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: i18n.ACTION_EXPORT_DESCRIPTION
    }, item.isExporting ? /*#__PURE__*/_react.default.createElement(AlignedSpinner, {
      size: "m"
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": i18n.ACTION_EXPORT_DESCRIPTION,
      "data-test-subj": "action-export-value-list",
      iconType: "exportAction",
      onClick: () => onExport(item)
    }))
  }, {
    render: item => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: i18n.ACTION_DELETE_DESCRIPTION
    }, item.isDeleting ? /*#__PURE__*/_react.default.createElement(AlignedSpinner, {
      size: "m"
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": i18n.ACTION_DELETE_DESCRIPTION,
      "data-test-subj": `action-delete-value-list-${item.name}`,
      iconType: "trash",
      onClick: () => onDelete(item)
    }))
  }],
  width: '15%'
}];
exports.buildColumns = buildColumns;