"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIconTypeFromStatus = exports.getBadgeColorFromStatus = exports.Status = exports.STATUS_CLASS_NAME = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const STATUS_CLASS_NAME = exports.STATUS_CLASS_NAME = 'alert-status-icon';
const StatusContainer = _styledComponents.default.span`
  display: inline-flex;
  justify-content: center;
  width: 100%;
`;
const getBadgeColorFromStatus = status => {
  switch (`${status}`.toLowerCase()) {
    case 'recovered':
      return 'hollow';
    default:
      return 'danger';
  }
};
exports.getBadgeColorFromStatus = getBadgeColorFromStatus;
const getIconTypeFromStatus = status => {
  switch (`${status}`.toLowerCase()) {
    case 'recovered':
      return 'check';
    default:
      return 'warning';
  }
};
exports.getIconTypeFromStatus = getIconTypeFromStatus;
const StatusComponent = ({
  status
}) => /*#__PURE__*/_react.default.createElement(StatusContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  className: STATUS_CLASS_NAME,
  color: getBadgeColorFromStatus(status),
  "data-test-subj": "status-icon",
  type: getIconTypeFromStatus(status)
}));
const Status = exports.Status = /*#__PURE__*/_react.default.memo(StatusComponent);