"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPDATE_PREPACKAGED_TIMELINES = exports.UPDATE_PREPACKAGED_RULES_AND_TIMELINES = exports.RULE_UPDATES_LINK = exports.RELOAD_MISSING_PREPACKAGED_TIMELINES = exports.RELOAD_MISSING_PREPACKAGED_RULES_AND_TIMELINES = exports.RELOAD_MISSING_PREPACKAGED_RULES = exports.RELEASE_NOTES_HELP = exports.PRE_BUILT_TITLE = exports.PRE_BUILT_MSG = exports.LOAD_PREPACKAGED_TIMELINE_TEMPLATES = exports.LOAD_PREPACKAGED_RULES_AND_TEMPLATES = exports.LOAD_PREPACKAGED_RULES = exports.DISMISS = exports.CREATE_RULE_ACTION = exports.ADD_ELASTIC_RULES = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PRE_BUILT_TITLE = exports.PRE_BUILT_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.prePackagedRules.emptyPromptTitle', {
  defaultMessage: 'Load Elastic prebuilt detection rules'
});
const PRE_BUILT_MSG = exports.PRE_BUILT_MSG = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.prePackagedRules.emptyPromptMessage', {
  defaultMessage: 'Elastic Security comes with prebuilt detection rules that run in the background and create alerts when their conditions are met. By default, all prebuilt rules except the Endpoint Security rule are disabled. You can select additional rules you want to enable.'
});
const CREATE_RULE_ACTION = exports.CREATE_RULE_ACTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.prePackagedRules.createOwnRuletButton', {
  defaultMessage: 'Create your own rules'
});
const RULE_UPDATES_LINK = exports.RULE_UPDATES_LINK = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.ruleUpdatesLinkTitle', {
  defaultMessage: 'Rule Updates'
});
const ADD_ELASTIC_RULES = exports.ADD_ELASTIC_RULES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.addElasticRulesButtonTitle', {
  defaultMessage: 'Add Elastic rules'
});
const DISMISS = exports.DISMISS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.dismissTitle', {
  defaultMessage: 'Dismiss'
});
const UPDATE_PREPACKAGED_TIMELINES = updateTimelines => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.updatePrePackagedTimelinesButton', {
  values: {
    updateTimelines
  },
  defaultMessage: 'Update {updateTimelines} Elastic prebuilt {updateTimelines, plural, =1 {timeline} other {timelines}}'
});
exports.UPDATE_PREPACKAGED_TIMELINES = UPDATE_PREPACKAGED_TIMELINES;
const UPDATE_PREPACKAGED_RULES_AND_TIMELINES = (updateRules, updateTimelines) => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.updatePrePackagedRulesAndTimelinesButton', {
  values: {
    updateRules,
    updateTimelines
  },
  defaultMessage: 'Update {updateRules} Elastic prebuilt {updateRules, plural, =1 {rule} other {rules}} and {updateTimelines} Elastic prebuilt {updateTimelines, plural, =1 {timeline} other {timelines}}'
});
exports.UPDATE_PREPACKAGED_RULES_AND_TIMELINES = UPDATE_PREPACKAGED_RULES_AND_TIMELINES;
const RELEASE_NOTES_HELP = exports.RELEASE_NOTES_HELP = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.releaseNotesHelp', {
  defaultMessage: 'Release notes'
});
const LOAD_PREPACKAGED_RULES = exports.LOAD_PREPACKAGED_RULES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.loadPrePackagedRulesButton', {
  defaultMessage: 'Load Elastic prebuilt rules'
});
const LOAD_PREPACKAGED_TIMELINE_TEMPLATES = exports.LOAD_PREPACKAGED_TIMELINE_TEMPLATES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.loadPrePackagedTimelineTemplatesButton', {
  defaultMessage: 'Load Elastic prebuilt timeline templates'
});
const LOAD_PREPACKAGED_RULES_AND_TEMPLATES = exports.LOAD_PREPACKAGED_RULES_AND_TEMPLATES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.loadPrePackagedRulesAndTemplatesButton', {
  defaultMessage: 'Load Elastic prebuilt rules and timeline templates'
});
const RELOAD_MISSING_PREPACKAGED_RULES = missingRules => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.reloadMissingPrePackagedRulesButton', {
  values: {
    missingRules
  },
  defaultMessage: 'Install {missingRules} Elastic prebuilt {missingRules, plural, =1 {rule} other {rules}} '
});
exports.RELOAD_MISSING_PREPACKAGED_RULES = RELOAD_MISSING_PREPACKAGED_RULES;
const RELOAD_MISSING_PREPACKAGED_TIMELINES = missingTimelines => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.reloadMissingPrePackagedTimelinesButton', {
  values: {
    missingTimelines
  },
  defaultMessage: 'Install {missingTimelines} Elastic prebuilt {missingTimelines, plural, =1 {timeline} other {timelines}} '
});
exports.RELOAD_MISSING_PREPACKAGED_TIMELINES = RELOAD_MISSING_PREPACKAGED_TIMELINES;
const RELOAD_MISSING_PREPACKAGED_RULES_AND_TIMELINES = (missingRules, missingTimelines) => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.reloadMissingPrePackagedRulesAndTimelinesButton', {
  values: {
    missingRules,
    missingTimelines
  },
  defaultMessage: 'Install {missingRules} Elastic prebuilt {missingRules, plural, =1 {rule} other {rules}} and {missingTimelines} Elastic prebuilt {missingTimelines, plural, =1 {timeline} other {timelines}} '
});
exports.RELOAD_MISSING_PREPACKAGED_RULES_AND_TIMELINES = RELOAD_MISSING_PREPACKAGED_RULES_AND_TIMELINES;