"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHostIsolationAction = void 0;
var _react = require("react");
var _kibana_react = require("../../../common/lib/kibana/kibana_react");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _sentinelone_alert_check = require("../../../common/utils/sentinelone_alert_check");
var _utils = require("../../../../common/endpoint/service/host_isolation/utils");
var _types = require("../../../../common/endpoint/types");
var _endpoint_alert_check = require("../../../common/utils/endpoint_alert_check");
var _use_host_isolation_status = require("../../containers/detection_engine/alerts/use_host_isolation_status");
var _translations = require("./translations");
var _helpers = require("./helpers");
var _user_privileges = require("../../../common/components/user_privileges");
var _use_sentinelone_host_isolation = require("./use_sentinelone_host_isolation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useHostIsolationAction = ({
  closePopover,
  detailsData,
  isHostIsolationPanelOpen,
  onAddIsolationStatusClick
}) => {
  var _useKibana$services$a, _useKibana$services$a2, _useKibana$services$a3;
  const hasActionsAllPrivileges = (_useKibana$services$a = (0, _kibana_react.useKibana)().services.application) === null || _useKibana$services$a === void 0 ? void 0 : (_useKibana$services$a2 = _useKibana$services$a.capabilities) === null || _useKibana$services$a2 === void 0 ? void 0 : (_useKibana$services$a3 = _useKibana$services$a2.actions) === null || _useKibana$services$a3 === void 0 ? void 0 : _useKibana$services$a3.save;
  const sentinelOneManualHostActionsEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('sentinelOneManualHostActionsEnabled');
  const {
    canIsolateHost,
    canUnIsolateHost
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const isEndpointAlert = (0, _react.useMemo)(() => (0, _endpoint_alert_check.isAlertFromEndpointEvent)({
    data: detailsData || []
  }), [detailsData]);
  const isSentinelOneAlert = (0, _react.useMemo)(() => (0, _sentinelone_alert_check.isAlertFromSentinelOneEvent)({
    data: detailsData || []
  }), [detailsData]);
  const agentId = (0, _react.useMemo)(() => (0, _helpers.getFieldValue)({
    category: 'agent',
    field: 'agent.id'
  }, detailsData), [detailsData]);
  const sentinelOneAgentId = (0, _react.useMemo)(() => (0, _sentinelone_alert_check.getSentinelOneAgentId)(detailsData), [detailsData]);
  const hostOsFamily = (0, _react.useMemo)(() => (0, _helpers.getFieldValue)({
    category: 'host',
    field: 'host.os.name'
  }, detailsData), [detailsData]);
  const agentVersion = (0, _react.useMemo)(() => (0, _helpers.getFieldValue)({
    category: 'agent',
    field: 'agent.version'
  }, detailsData), [detailsData]);
  const {
    loading: loadingHostIsolationStatus,
    isIsolated,
    agentStatus,
    capabilities
  } = (0, _use_host_isolation_status.useEndpointHostIsolationStatus)({
    agentId,
    agentType: sentinelOneAgentId ? 'sentinel_one' : 'endpoint'
  });
  const {
    data: sentinelOneAgentData
  } = (0, _use_sentinelone_host_isolation.useGetSentinelOneAgentStatus)([sentinelOneAgentId || ''], {
    enabled: !!sentinelOneAgentId && sentinelOneManualHostActionsEnabled
  });
  const sentinelOneAgentStatus = sentinelOneAgentData === null || sentinelOneAgentData === void 0 ? void 0 : sentinelOneAgentData[`${sentinelOneAgentId}`];
  const isHostIsolated = (0, _react.useMemo)(() => {
    if (sentinelOneManualHostActionsEnabled && isSentinelOneAlert) {
      return sentinelOneAgentStatus === null || sentinelOneAgentStatus === void 0 ? void 0 : sentinelOneAgentStatus.isolated;
    }
    return isIsolated;
  }, [isIsolated, isSentinelOneAlert, sentinelOneAgentStatus === null || sentinelOneAgentStatus === void 0 ? void 0 : sentinelOneAgentStatus.isolated, sentinelOneManualHostActionsEnabled]);
  const doesHostSupportIsolation = (0, _react.useMemo)(() => {
    if (isEndpointAlert) {
      return (0, _utils.isIsolationSupported)({
        osName: hostOsFamily,
        version: agentVersion,
        capabilities
      });
    }
    if (sentinelOneManualHostActionsEnabled && isSentinelOneAlert && sentinelOneAgentStatus) {
      return sentinelOneAgentStatus.status === 'healthy';
    }
    return false;
  }, [agentVersion, capabilities, hostOsFamily, isEndpointAlert, isSentinelOneAlert, sentinelOneAgentStatus, sentinelOneManualHostActionsEnabled]);
  const isolateHostHandler = (0, _react.useCallback)(() => {
    closePopover();
    if (!isHostIsolated) {
      onAddIsolationStatusClick('isolateHost');
    } else {
      onAddIsolationStatusClick('unisolateHost');
    }
  }, [closePopover, isHostIsolated, onAddIsolationStatusClick]);
  const isIsolationActionDisabled = (0, _react.useMemo)(() => {
    if (sentinelOneManualHostActionsEnabled && isSentinelOneAlert) {
      return !sentinelOneAgentStatus || (sentinelOneAgentStatus === null || sentinelOneAgentStatus === void 0 ? void 0 : sentinelOneAgentStatus.isUninstalled) || (sentinelOneAgentStatus === null || sentinelOneAgentStatus === void 0 ? void 0 : sentinelOneAgentStatus.isPendingUninstall);
    }
    return agentStatus === _types.HostStatus.UNENROLLED;
  }, [agentStatus, isSentinelOneAlert, sentinelOneAgentStatus, sentinelOneManualHostActionsEnabled]);
  const menuItems = (0, _react.useMemo)(() => [{
    key: 'isolate-host-action-item',
    'data-test-subj': 'isolate-host-action-item',
    disabled: isIsolationActionDisabled,
    onClick: isolateHostHandler,
    name: isHostIsolated ? _translations.UNISOLATE_HOST : _translations.ISOLATE_HOST
  }], [isHostIsolated, isolateHostHandler, isIsolationActionDisabled]);
  return (0, _react.useMemo)(() => {
    if (isHostIsolationPanelOpen) {
      return [];
    }
    if (isSentinelOneAlert && sentinelOneManualHostActionsEnabled && sentinelOneAgentId && sentinelOneAgentStatus && hasActionsAllPrivileges) {
      return menuItems;
    }
    if (isEndpointAlert && doesHostSupportIsolation && !loadingHostIsolationStatus && (canIsolateHost || isHostIsolated && !canUnIsolateHost)) {
      return menuItems;
    }
    return [];
  }, [canIsolateHost, canUnIsolateHost, doesHostSupportIsolation, hasActionsAllPrivileges, isEndpointAlert, isHostIsolated, isHostIsolationPanelOpen, isSentinelOneAlert, loadingHostIsolationStatus, menuItems, sentinelOneAgentStatus, sentinelOneAgentId, sentinelOneManualHostActionsEnabled]);
};
exports.useHostIsolationAction = useHostIsolationAction;