"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostIsolationPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _sentinelone_alert_check = require("../../../common/utils/sentinelone_alert_check");
var _use_cases_from_alerts = require("../../containers/detection_engine/alerts/use_cases_from_alerts");
var _helpers = require("./helpers");
var _isolate = require("./isolate");
var _unisolate = require("./unisolate");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HostIsolationPanel = exports.HostIsolationPanel = /*#__PURE__*/_react.default.memo(({
  details,
  cancelCallback,
  successCallback,
  isolateAction
}) => {
  const elasticAgentId = (0, _react.useMemo)(() => (0, _helpers.getFieldValue)({
    category: 'agent',
    field: 'agent.id'
  }, details), [details]);
  const sentinelOneAgentId = (0, _react.useMemo)(() => (0, _sentinelone_alert_check.getSentinelOneAgentId)(details), [details]);
  const hostName = (0, _react.useMemo)(() => (0, _helpers.getFieldValue)({
    category: 'host',
    field: 'host.name'
  }, details), [details]);
  const alertId = (0, _react.useMemo)(() => (0, _helpers.getFieldValue)({
    category: '_id',
    field: '_id'
  }, details), [details]);
  const {
    casesInfo
  } = (0, _use_cases_from_alerts.useCasesFromAlerts)({
    alertId
  });
  const agentType = (0, _react.useMemo)(() => sentinelOneAgentId ? 'sentinel_one' : 'endpoint', [sentinelOneAgentId]);
  const endpointId = (0, _react.useMemo)(() => sentinelOneAgentId !== null && sentinelOneAgentId !== void 0 ? sentinelOneAgentId : elasticAgentId, [elasticAgentId, sentinelOneAgentId]);
  return isolateAction === 'isolateHost' ? /*#__PURE__*/_react.default.createElement(_isolate.IsolateHost, {
    endpointId: endpointId,
    hostName: hostName,
    casesInfo: casesInfo,
    agentType: agentType,
    cancelCallback: cancelCallback,
    successCallback: successCallback
  }) : /*#__PURE__*/_react.default.createElement(_unisolate.UnisolateHost, {
    endpointId: endpointId,
    hostName: hostName,
    casesInfo: casesInfo,
    agentType: agentType,
    cancelCallback: cancelCallback,
    successCallback: successCallback
  });
});
HostIsolationPanel.displayName = 'HostIsolationContent';