"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useResponderActionItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _sentinelone_alert_check = require("../../../common/utils/sentinelone_alert_check");
var _user_privileges = require("../../../common/components/user_privileges");
var _endpoint_alert_check = require("../../../common/utils/endpoint_alert_check");
var _helpers = require("../host_isolation/helpers");
var _use_responder_action_data = require("./use_responder_action_data");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useResponderActionItem = (eventDetailsData, onClick) => {
  const {
    loading: isAuthzLoading,
    canAccessResponseConsole
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const isAlert = (0, _react.useMemo)(() => {
    return (0, _endpoint_alert_check.isTimelineEventItemAnAlert)(eventDetailsData || []);
  }, [eventDetailsData]);
  const endpointId = (0, _react.useMemo)(() => (0, _helpers.getFieldValue)({
    category: 'agent',
    field: 'agent.id'
  }, eventDetailsData), [eventDetailsData]);
  const agentType = (0, _react.useMemo)(() => eventDetailsData ? (0, _sentinelone_alert_check.isAlertFromSentinelOneEvent)({
    data: eventDetailsData
  }) ? 'sentinel_one' : 'endpoint' : 'endpoint', [eventDetailsData]);
  const {
    handleResponseActionsClick,
    isDisabled,
    tooltip
  } = (0, _use_responder_action_data.useResponderActionData)({
    endpointId,
    onClick,
    agentType,
    eventData: agentType !== 'endpoint' ? eventDetailsData : null
  });
  return (0, _react.useMemo)(() => {
    const actions = [];
    if (!isAuthzLoading && canAccessResponseConsole && isAlert) {
      actions.push({
        key: 'endpointResponseActions-action-item',
        'data-test-subj': 'endpointResponseActions-action-item',
        disabled: isDisabled,
        toolTipContent: tooltip,
        size: 's',
        onClick: handleResponseActionsClick,
        name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.endpoint.detections.takeAction.responseActionConsole.buttonLabel",
          defaultMessage: "Respond"
        })
      });
    }
    return actions;
  }, [canAccessResponseConsole, handleResponseActionsClick, isAlert, isAuthzLoading, isDisabled, tooltip]);
};
exports.useResponderActionItem = useResponderActionItem;