"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetectionEngineFilters = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _public = require("@kbn/kibana-utils-plugin/public");
var _public2 = require("@kbn/controls-plugin/public");
var _alert_filter_controls = require("@kbn/alerts-ui-shared/src/alert_filter_controls");
var _reactRouterDom = require("react-router-dom");
var _kibana = require("../../../common/lib/kibana");
var _constants = require("../../../../common/constants");
var _use_url_state = require("../../../common/hooks/use_url_state");
var _use_space_id = require("../../../common/hooks/use_space_id");
var _constants2 = require("../../constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DetectionEngineFilters = ({
  indexPattern,
  ...props
}) => {
  const {
    http,
    notifications,
    dataViews
  } = (0, _kibana.useKibana)().services;
  const spaceId = (0, _use_space_id.useSpaceId)();
  const history = (0, _reactRouterDom.useHistory)();
  const urlStorage = (0, _react.useMemo)(() => (0, _public.createKbnUrlStateStorage)({
    history,
    useHash: false,
    useHashQuery: false
  }), [history]);
  const filterControlsUrlState = (0, _react.useMemo)(() => {
    var _urlStorage$get;
    return (_urlStorage$get = urlStorage.get(_use_url_state.URL_PARAM_KEY.pageFilter)) !== null && _urlStorage$get !== void 0 ? _urlStorage$get : undefined;
  }, [urlStorage]);
  const setFilterControlsUrlState = (0, _react.useCallback)(newFilterControls => {
    urlStorage.set(_use_url_state.URL_PARAM_KEY.pageFilter, newFilterControls);
  }, [urlStorage]);
  const dataViewSpec = (0, _react.useMemo)(() => indexPattern ? {
    id: _constants2.SECURITY_ALERT_DATA_VIEW.id,
    name: _constants2.SECURITY_ALERT_DATA_VIEW.name,
    allowNoIndex: true,
    title: indexPattern.title,
    timeFieldName: '@timestamp'
  } : null, [indexPattern]);
  if (!spaceId || !dataViewSpec) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_alert_filter_controls.AlertFilterControls, (0, _extends2.default)({
    controlsUrlState: filterControlsUrlState,
    setControlsUrlState: setFilterControlsUrlState,
    spaceId: spaceId,
    featureIds: [_ruleDataUtils.AlertConsumers.SIEM],
    chainingSystem: "HIERARCHICAL",
    defaultControls: _constants.DEFAULT_DETECTION_PAGE_FILTERS,
    dataViewSpec: dataViewSpec,
    services: {
      http,
      notifications,
      dataViews,
      storage: _public.Storage
    },
    ControlGroupRenderer: _public2.ControlGroupRenderer,
    maxControls: 4
  }, props));
};
exports.DetectionEngineFilters = DetectionEngineFilters;