"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupedAlertsTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _securitysolutionGrouping = require("@kbn/securitysolution-grouping");
var _fp = require("lodash/fp");
var _selectors = require("../../../common/store/grouping/selectors");
var _alerts = require("../../../common/utils/alerts");
var _use_selector = require("../../../common/hooks/use_selector");
var _actions = require("../../../common/store/grouping/actions");
var _unit = require("../../../common/components/toolbar/unit");
var _sourcerer = require("../../../common/containers/sourcerer");
var _model = require("../../../common/store/sourcerer/model");
var _grouping_settings = require("./grouping_settings");
var _kibana = require("../../../common/lib/kibana");
var _alerts_sub_grouping = require("./alerts_sub_grouping");
var _telemetry = require("../../../common/lib/telemetry");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_PAGE_SIZE = 25;
const DEFAULT_PAGE_INDEX = 0;
const MAX_GROUPING_LEVELS = 3;
const useStorage = (storage, tableId) => (0, _react.useMemo)(() => ({
  getStoragePageSize: () => {
    const pageSizes = storage.get(`grouping-table-${tableId}`);
    if (!pageSizes) {
      return Array(MAX_GROUPING_LEVELS).fill(DEFAULT_PAGE_SIZE);
    }
    return pageSizes;
  },
  setStoragePageSize: pageSizes => {
    storage.set(`grouping-table-${tableId}`, pageSizes);
  }
}), [storage, tableId]);
const GroupedAlertsTableComponent = props => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    indexPattern,
    selectedPatterns
  } = (0, _sourcerer.useSourcererDataView)(_model.SourcererScopeName.detections);
  const {
    services: {
      storage,
      telemetry
    }
  } = (0, _kibana.useKibana)();
  const {
    getStoragePageSize,
    setStoragePageSize
  } = useStorage(storage, props.tableId);
  const {
    onGroupChange,
    onGroupToggle
  } = (0, _react.useMemo)(() => ({
    onGroupChange: ({
      groupByField,
      tableId
    }) => {
      telemetry.reportAlertsGroupingChanged({
        groupByField,
        tableId
      });
    },
    onGroupToggle: param => telemetry.reportAlertsGroupingToggled({
      ...param,
      tableId: param.groupingId
    })
  }), [telemetry]);
  const onOptionsChange = (0, _react.useCallback)(options => {
    dispatch((0, _actions.updateGroups)({
      tableId: props.tableId,
      options
    }));
  }, [dispatch, props.tableId]);
  const {
    getGrouping,
    selectedGroups,
    setSelectedGroups
  } = (0, _securitysolutionGrouping.useGrouping)({
    componentProps: {
      groupPanelRenderer: _grouping_settings.renderGroupPanel,
      groupStatsRenderer: _grouping_settings.getStats,
      onGroupToggle,
      unit: _unit.defaultUnit
    },
    defaultGroupingOptions: (0, _alerts.getDefaultGroupingOptions)(props.tableId),
    fields: indexPattern.fields,
    groupingId: props.tableId,
    maxGroupingLevels: MAX_GROUPING_LEVELS,
    onGroupChange,
    onOptionsChange,
    tracker: _telemetry.track
  });
  const groupId = (0, _react.useMemo)(() => (0, _selectors.groupIdSelector)(), []);
  const groupInRedux = (0, _use_selector.useDeepEqualSelector)(state => groupId(state, props.tableId));
  (0, _react.useEffect)(() => {
    // only ever set to `none` - siem only handles group selector when `none` is selected
    if ((0, _securitysolutionGrouping.isNoneGroup)(selectedGroups)) {
      // set active groups from selected groups
      dispatch((0, _actions.updateGroups)({
        activeGroups: selectedGroups,
        tableId: props.tableId
      }));
    }
  }, [dispatch, props.tableId, selectedGroups]);
  (0, _react.useEffect)(() => {
    if (groupInRedux != null && !(0, _securitysolutionGrouping.isNoneGroup)(groupInRedux.activeGroups)) {
      // set selected groups from active groups
      setSelectedGroups(groupInRedux.activeGroups);
    }
  }, [groupInRedux, setSelectedGroups]);
  const [pageIndex, setPageIndex] = (0, _react.useState)(Array(MAX_GROUPING_LEVELS).fill(DEFAULT_PAGE_INDEX));
  const [pageSize, setPageSize] = (0, _react.useState)(getStoragePageSize);
  const resetAllPagination = (0, _react.useCallback)(() => {
    setPageIndex(curr => curr.map(() => DEFAULT_PAGE_INDEX));
  }, []);
  const setPageVar = (0, _react.useCallback)((newNumber, groupingLevel, pageType) => {
    if (pageType === 'index') {
      setPageIndex(currentIndex => {
        const newArr = [...currentIndex];
        newArr[groupingLevel] = newNumber;
        return newArr;
      });
    }
    if (pageType === 'size') {
      setPageSize(currentIndex => {
        const newArr = [...currentIndex];
        newArr[groupingLevel] = newNumber;
        setStoragePageSize(newArr);
        return newArr;
      });
      // set page index to 0 when page size is changed
      setPageIndex(currentIndex => {
        const newArr = [...currentIndex];
        newArr[groupingLevel] = 0;
        return newArr;
      });
    }
  }, [setStoragePageSize]);
  const paginationResetTriggers = (0, _react.useRef)({
    defaultFilters: props.defaultFilters,
    globalFilters: props.globalFilters,
    globalQuery: props.globalQuery,
    selectedGroups
  });
  (0, _react.useEffect)(() => {
    const triggers = {
      defaultFilters: props.defaultFilters,
      globalFilters: props.globalFilters,
      globalQuery: props.globalQuery,
      selectedGroups
    };
    if (!(0, _fp.isEqual)(paginationResetTriggers.current, triggers)) {
      resetAllPagination();
      paginationResetTriggers.current = triggers;
    }
  }, [props.defaultFilters, props.globalFilters, props.globalQuery, resetAllPagination, selectedGroups]);
  const getLevel = (0, _react.useCallback)((level, selectedGroup, parentGroupingFilter) => {
    var _pageIndex$level, _pageSize$level;
    let rcc;
    if (level < selectedGroups.length - 1) {
      rcc = groupingFilters => {
        return getLevel(level + 1, selectedGroups[level + 1],
        // stringify because if the filter is passed as an object, it will cause unnecessary re-rendering
        JSON.stringify([...groupingFilters, ...(parentGroupingFilter ? JSON.parse(parentGroupingFilter) : [])]));
      };
    } else {
      rcc = groupingFilters => {
        return props.renderChildComponent([...groupingFilters, ...(parentGroupingFilter ? JSON.parse(parentGroupingFilter) : [])]);
      };
    }
    const resetGroupChildrenPagination = parentLevel => {
      setPageIndex(allPages => {
        const resetPages = allPages.splice(parentLevel + 1, allPages.length);
        return [...allPages, ...resetPages.map(() => DEFAULT_PAGE_INDEX)];
      });
    };
    return /*#__PURE__*/_react.default.createElement(_alerts_sub_grouping.GroupedSubLevel, (0, _extends2.default)({}, props, {
      getGrouping: getGrouping,
      groupingLevel: level,
      onGroupClose: () => resetGroupChildrenPagination(level),
      pageIndex: (_pageIndex$level = pageIndex[level]) !== null && _pageIndex$level !== void 0 ? _pageIndex$level : DEFAULT_PAGE_INDEX,
      pageSize: (_pageSize$level = pageSize[level]) !== null && _pageSize$level !== void 0 ? _pageSize$level : DEFAULT_PAGE_SIZE,
      parentGroupingFilter: parentGroupingFilter,
      renderChildComponent: rcc,
      selectedGroup: selectedGroup,
      setPageIndex: newIndex => setPageVar(newIndex, level, 'index'),
      setPageSize: newSize => setPageVar(newSize, level, 'size')
    }));
  }, [getGrouping, pageIndex, pageSize, props, selectedGroups, setPageVar]);
  if ((0, _fp.isEmpty)(selectedPatterns)) {
    return null;
  }
  return getLevel(0, selectedGroups[0]);
};
const GroupedAlertsTable = exports.GroupedAlertsTable = /*#__PURE__*/_react.default.memo(GroupedAlertsTableComponent);