"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsSummaryChartsPanel = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var i18n = _interopRequireWildcard(require("./translations"));
var _components = require("../common/components");
var _header_section = require("../../../../common/components/header_section");
var _severity_level_panel = require("../severity_level_panel");
var _alerts_by_type_panel = require("../alerts_by_type_panel");
var _alerts_progress_bar_panel = require("../alerts_progress_bar_panel");
var _query_toggle = require("../../../../common/containers/query_toggle");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  @media only screen and (min-width: ${({
  theme
}) => theme.eui.euiBreakpoints.l});
`;
const StyledFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  min-width: 355px;
`;
const DETECTIONS_ALERTS_CHARTS_ID = 'detections-alerts-charts';
const AlertsSummaryChartsPanel = ({
  alignHeader,
  filters,
  addFilter,
  panelHeight,
  query,
  runtimeMappings,
  signalIndexName,
  title = i18n.CHARTS_TITLE,
  isExpanded,
  setIsExpanded,
  groupBySelection,
  setGroupBySelection
}) => {
  const isAlertsPageChartsEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('alertsPageChartsEnabled');
  const {
    toggleStatus,
    setToggleStatus
  } = (0, _query_toggle.useQueryToggle)(DETECTIONS_ALERTS_CHARTS_ID);
  const toggleQuery = (0, _react.useCallback)(status => {
    if (isAlertsPageChartsEnabled && setIsExpanded) {
      setIsExpanded(status);
    } else {
      setToggleStatus(status);
    }
  }, [setToggleStatus, setIsExpanded, isAlertsPageChartsEnabled]);
  const querySkip = (0, _react.useMemo)(() => isAlertsPageChartsEnabled ? !isExpanded : !toggleStatus, [isAlertsPageChartsEnabled, isExpanded, toggleStatus]);
  const status = (0, _react.useMemo)(() => {
    if (isAlertsPageChartsEnabled && isExpanded) {
      return true;
    }
    if (!isAlertsPageChartsEnabled && toggleStatus) {
      return true;
    }
    return false;
  }, [isAlertsPageChartsEnabled, isExpanded, toggleStatus]);
  return /*#__PURE__*/_react.default.createElement(_components.KpiPanel, {
    $toggleStatus: isAlertsPageChartsEnabled && isExpanded !== undefined ? isExpanded : toggleStatus,
    "data-test-subj": "alerts-charts-panel",
    hasBorder: true,
    height: panelHeight
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    alignHeader: alignHeader,
    outerDirection: "row",
    title: title,
    titleSize: "s",
    hideSubtitle: true,
    showInspectButton: false,
    toggleStatus: isAlertsPageChartsEnabled ? isExpanded : toggleStatus,
    toggleQuery: toggleQuery
  }), status && /*#__PURE__*/_react.default.createElement(StyledFlexGroup, {
    "data-test-subj": "alerts-charts-container",
    className: "eui-yScroll",
    wrap: true,
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(StyledFlexItem, null, /*#__PURE__*/_react.default.createElement(_severity_level_panel.SeverityLevelPanel, {
    filters: filters,
    query: query,
    signalIndexName: signalIndexName,
    runtimeMappings: runtimeMappings,
    skip: querySkip,
    addFilter: addFilter
  })), /*#__PURE__*/_react.default.createElement(StyledFlexItem, null, /*#__PURE__*/_react.default.createElement(_alerts_by_type_panel.AlertsByTypePanel, {
    filters: filters,
    query: query,
    signalIndexName: signalIndexName,
    runtimeMappings: runtimeMappings,
    skip: querySkip
  })), /*#__PURE__*/_react.default.createElement(StyledFlexItem, null, /*#__PURE__*/_react.default.createElement(_alerts_progress_bar_panel.AlertsProgressBarPanel, {
    filters: filters,
    query: query,
    signalIndexName: signalIndexName,
    runtimeMappings: runtimeMappings,
    skip: querySkip,
    groupBySelection: groupBySelection,
    setGroupBySelection: setGroupBySelection,
    addFilter: addFilter
  }))));
};
exports.AlertsSummaryChartsPanel = AlertsSummaryChartsPanel;
AlertsSummaryChartsPanel.displayName = 'AlertsSummaryChartsPanel';